<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Contact;
use Alert;

class ContactMessageController extends Controller
{
    public function pending_contact_messages()
    {
        $datas = Contact::where('status', 0)->orderBy('id', 'desc')->get();
        return view('admin.contact_message.pending_contact_messages', compact('datas'));
    }
    public function completed_contact_messages()
    {
        $datas = Contact::where('status', 1)->orderBy('id', 'desc')->get();
        return view('admin.contact_message.completed_contact_messages', compact('datas'));
    }

    public function edit_contact_messages($id)
    {
        $data = Contact::find($id);
        return view('admin.contact_message.edit_contact_messages', compact('data'));
    }

    public function update_contact_messages(Request $request, $id)
    {

        $data = Contact::find($id);
        $data->full_name = $request->full_name;
        $data->phone_number = $request->phone_number;
        $data->message = $request->message;
        $data->status = $request->status;
        $data->save();

        Alert::success('Updated successfull', '');
        return redirect()->back();

    }

    public function delete_contact_messages($id)
    {
        $data = Contact::find($id);
        $data->delete();

        Alert::error('Successfully done', '');
        return redirect()->back();
    }

}
