<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\Product;
use Alert;

class OrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    public function pending_order()
    {
        $datas = Order::orderBy('id', 'desc')->where('status', 0)->get();
        return view('admin.order.pending_order', compact('datas'));
    }


    public function confirmed_order()
    {
        $datas = Order::orderBy('id', 'desc')->where('status', 1)->get();
        return view('admin.order.confirmed_order', compact('datas'));
    }


    public function rejected_order()
    {
        $datas = Order::orderBy('id', 'desc')->where('status', 2)->get();
        return view('admin.order.rejected_order', compact('datas'));
    }

    public function in_transit_order()
    {
        $datas = Order::orderBy('id', 'desc')->where('status', 4)->get();
        return view('admin.order.in_transit_order', compact('datas'));
    }

    public function delivered_order()
    {
        $datas = Order::orderBy('id', 'desc')->where('status', 5)->get();
        return view('admin.order.delivered_order', compact('datas'));
    }

    public function canceled_order()
    {
        $datas = Order::orderBy('id', 'desc')->where('status', 6)->get();
        return view('admin.order.canceled_order', compact('datas'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $data = Order::find($id);

        $product = Product::where('id', $data->product_id)->first();

        $data->name = $request->name;
        $data->phone_number = $request->phone_number;
        $data->district = $request->district ?? null;
        $data->devlivery_address = $request->devlivery_address ?? null;


        $data->product_id = $product->id;

        $data->color_id = $request->color_id ?? null;


        $data->unit_price = $product->price;
        $data->quantity = $request->quantity;
        $data->shipping_charge = $request->shipping_charge ?? 0;
        $data->discount = $request->discount ?? 0;
        $data->total = $request->quantity * $product->price;
        $data->payment_method = 'Cash on delivery';
        $data->payment_status = $request->payment_status;

        $data->advance = $request->advance;
        $data->cash_collection = $request->cash_collection;
        $data->note = $request->note;


        $data->status = $request->status;
        $data->pending_status = 1;

        if($request->status == 1){
            $data->confirm_status = 1;
        }

        if($request->status == 2){
            $data->reject_status = 1;
        }

        if($request->status == 3){
            $data->processing_status = 1;
        }

        if($request->status == 4){
            $data->in_transit_status = 1;
        }
        
        if($request->status == 5){
            $data->delivered_status = 1;
        }
        
        if($request->status == 6){
            $data->canceled_status = 1;
        }
        
        $data->save();

        Alert::success('Successfully done', 'Your order submitted successfull');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Order::find($id);
        $data->delete();

        Alert::error('Successfully done', '');
        return redirect()->back();
    }

    public function edit_order_model(Request $request)
    {
        $order_id = $request->order_id;
        $data = Order::where('id', $order_id)->first();

        $product = Product::where('id', $data->product_id)->first();

        return view('admin.order.edit_order_model', compact('order_id', 'data', 'product'));
    }

    public function delete_model(Request $request)
    {
        $order_id = $request->order_id;
        $item = Order::where('id', $order_id)->first();
        return view('admin.order.delete_model', compact('order_id', 'item'));
    }
}
