<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PageCategory;
use App\Models\Page;
use Illuminate\Http\Request;
Use Alert;


class PageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_categories = PageCategory::get();
        $datas = Page::get();

        return view('admin.page.index',compact('page_categories', 'datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $page_categories = PageCategory::all();
        return view('admin.page.create', compact('page_categories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'title' => 'required',
            'page_category_id' => 'required',
        ]);

        $data = new Page();
        $data->page_category_id=$request->page_category_id;
        $data->title=$request->title;
        $data->slug = $this->seo_slug($request->title);
        $data->page_description=$request->page_description;
        $data->status=$request->status;
        $data->save();

        Alert::success('Successfully done', '');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $page_categories = PageCategory::get();
        $data = Page::where('id',$id)->first();

        return view('admin.page.edit',compact('data', 'page_categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'title' => 'required',
        ]);
        $data = Page::find($id);
        $data->page_category_id=$request->page_category_id;
        $data->title=$request->title;
        $data->slug = $this->seo_slug($request->title);
        $data->page_description=$request->page_description;
        $data->status=$request->status;
        $data->save();

        Alert::success('Successfully done', '');
        return redirect()->back();

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Page::find($id);
        $data->delete();

        Alert::error('Successfully done', '');
        return redirect()->back();
    }


    
    public function seo_slug($string)
    {
        
        $string=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
        $string=strtolower($string);
        return $string; 
    
    }
    

    
    public function img_slug($string)
    {
        
        $string=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
        $string=strtolower($string);
        return $string; 
    
    }
    
    
    public function non_seo_slug($string)
    {
        $string=str_replace(" ","-",$string);
        $string=strtolower($string);
        return $string; 
    
    }


}
