<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PageDiscription;
use Alert;


class PageDescriptionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = PageDiscription::first();
        return view('admin.page_description.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $aboutus = PageDiscription::first();

        if($aboutus){

            $data = PageDiscription::find($aboutus->id);
            $data->visa_page_description = $request->visa_page_description;
            $data->tour_page_description = $request->tour_page_description;
            $data->umrah_page_description = $request->umrah_page_description;
            $data->contact_page_description = $request->contact_page_description;
            $data->footer_description = $request->footer_description;
            $data->save();

        }else{

            $data = new PageDiscription();
            $data->visa_page_description = $request->visa_page_description;
            $data->tour_page_description = $request->tour_page_description;
            $data->umrah_page_description = $request->umrah_page_description;
            $data->contact_page_description = $request->contact_page_description;
            $data->footer_description = $request->footer_description;
            $data->save();

        }

        Alert::success('Successfully done', '');
        return redirect()->back();


    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
