<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ProgramCategory;
use App\Models\Program;
use Illuminate\Http\Request;
Use Alert;


class ProgramController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $program_categories = ProgramCategory::get();
        $datas = Program::get();

        return view('admin.program.index',compact('program_categories', 'datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $program_categories = ProgramCategory::all();
        return view('admin.program.create', compact('program_categories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required',
            'program_category_id' => 'required',
        ]);

        $data = new Program();
        $data->program_category_id=$request->program_category_id;
        $data->name=$request->name;
        $data->slug = $this->seo_slug($request->name);
        $data->status=$request->status;
        $data->save();

        Alert::success('Successfully done', '');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $program_categories = ProgramCategory::get();

        $data = Program::where('id',$id)->first();

        return view('admin.program.edit',compact('data', 'program_categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'name' => 'required',
        ]);
        $data = Program::find($id);
        $data->program_category_id=$request->program_category_id;
        $data->name=$request->name;
        $data->slug = $this->seo_slug($request->name);
        $data->status=$request->status;
        $data->save();

        Alert::success('Successfully done', '');
        return redirect()->back();

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Program::find($id);
        $data->delete();

        Alert::error('Successfully done', '');
        return redirect()->back();
    }


    
    public function seo_slug($string)
    {
        
        $string=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
        $string=strtolower($string);
        return $string; 
    
    }
    

    
    public function img_slug($string)
    {
        
        $string=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
        $string=strtolower($string);
        return $string; 
    
    }
    
    
    public function non_seo_slug($string)
    {
        $string=str_replace(" ","-",$string);
        $string=strtolower($string);
        return $string; 
    
    }


}
