<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Continent;
use App\Models\TourService;
use App\Models\TourServiceImage;
use App\Models\TourServiceCountry;
use App\Models\Country;
use Alert;

class TourServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = TourService::orderBy('id', 'desc')->get();
        return view('admin.tour_service.index', compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $continents = Continent::where('status', 1)->get();
        return view('admin.tour_service.create', compact('continents'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'continent_id' => 'required',
            'country_id.*' => 'required',
            'title' => 'required',
            'price_start_per_person' => 'required',
        ]);

        $data = new TourService();
        $data->continent_id = $request->continent_id;
        $data->title = $request->title;
        $data->slug = $this->seo_slug($request->title);
        $data->price_start_per_person = $request->price_start_per_person;
        $data->tour_details = $request->tour_details;
        $data->tour_other_information = $request->tour_other_information;
        $data->tour_faq = $request->tour_faq;
        $data->tour_remark = $request->tour_remark;
        $data->tour_itinerary = $request->tour_itinerary;
        $data->best_tour_service_for = $request->best_tour_service_for;
        $data->meta_title = $request->meta_title;
        $data->meta_description = $request->meta_description;
        $data->meta_keywords = $request->meta_keywords;

        $meta_image = $request->file('meta_image');
        if($meta_image)
        {
            $image_name= time().'_'.$meta_image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/tour_service_meta_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $meta_image->move($upload_path, $image_full_name);
            if($success)
            {
                $data->meta_image = $image_url;
            }
        }

        $data->status = $request->status;
        $data->save();


        $country_id = $request->country_id;

        if($country_id){

            foreach ($country_id as $key => $value ){
                $tour_image = new TourServiceCountry();
                $tour_image->tour_service_id = $data->id;
                $tour_image->country_id = $value;
                $tour_image->save();
            }

        }



        $file = $request->file('image');

        if($file){

            foreach ($file as $key => $value ){
                $tour_image = new TourServiceImage();
                $image_name=time().$data->id.'_'.$value->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/tour_service_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $value->move($upload_path, $image_full_name);
                $tour_image->tour_service_id = $data->id;
                $tour_image->image = $image_url;
                $tour_image->save();
            }

        }


        Alert::success('Successfully done', '');
        return redirect()->back();
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $data = TourService::find($id);
        $tour_service_images = TourServiceImage::where('tour_service_id', $id)->get();

        $continents = Continent::where('status', 1)->get();
        $countries = Country::where('continent_id', $data->continent_id)->where('status', 1)->get();

        $tour_countries = TourServiceCountry::where('tour_service_id', $id)->get();

        return view('admin.tour_service.edit', compact('continents', 'data', 'tour_service_images', 'countries', 'tour_countries'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = TourService::find($id);
        $data->continent_id = $request->continent_id;
        $data->title = $request->title;
        $data->slug = $this->seo_slug($request->title);
        $data->price_start_per_person = $request->price_start_per_person;
        $data->tour_details = $request->tour_details;
        $data->tour_other_information = $request->tour_other_information;
        $data->tour_faq = $request->tour_faq;
        $data->tour_remark = $request->tour_remark;
        $data->tour_itinerary = $request->tour_itinerary;
        $data->best_tour_service_for = $request->best_tour_service_for;
        $data->meta_title = $request->meta_title;
        $data->meta_description = $request->meta_description;
        $data->meta_keywords = $request->meta_keywords;

        $meta_image = $request->file('meta_image');
        if($meta_image)
        {
            $image_name= time().'_'.$meta_image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/tour_service_meta_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $meta_image->move($upload_path, $image_full_name);
            if($success)
            {

                $old_meta_image = $request->old_meta_image;
                if (file_exists($old_meta_image)) {
                    unlink($request->old_meta_image);
                }


                $data->meta_image = $image_url;
            }
        }

        $data->status = $request->status;
        $data->save();



        $country_id = $request->country_id;
        if($country_id){
            TourServiceCountry::where('tour_service_id', $id)->delete();

            foreach ($country_id as $key => $value ){
                $tour_image = new TourServiceCountry();
                $tour_image->tour_service_id = $data->id;
                $tour_image->country_id = $value;
                $tour_image->save();
            }

        }


        $file = $request->file('image');
        if($file){

            $tour_service_images = TourServiceImage::select('image')->where('tour_service_id', $id)->get();
            foreach ($tour_service_images as $key => $value) {
                unlink($value->image);
            }

            foreach ($file as $key => $value ){

                $tour_image = new TourServiceImage();
                $image_name=time().$data->id.'_'.$value->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/tour_service_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $value->move($upload_path, $image_full_name);
                $tour_image->tour_service_id = $data->id;
                $tour_image->image = $image_url;
                $tour_image->save();

            }

        }


        Alert::success('Successfully done', '');
        return redirect()->back();
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $tour_service = TourService::where('id', $id)->first();

        $filePath = $tour_service->image;

        if (file_exists($filePath)) {
            unlink($filePath);
        }


        $tour_service_images = TourServiceImage::select('image')->where('tour_service_id', $id)->get();

        if(count($tour_service_images) > 0){

            foreach ($tour_service_images as $key => $value) {
                unlink($value->image);
            }

        }

        TourServiceCountry::where('tour_service_id', $id)->delete();

        TourService::where('id', $id)->delete();


        Alert::error('Successfully done', '');
        return redirect()->back();
    }

    public function delete_tour_service_image($id)
    {
        $imagePath = TourServiceImage::select('image')->where('id', $id)->first();

        $filePath = $imagePath->image;

        if (file_exists($filePath)) {
            unlink($filePath);
        }

        TourServiceImage::where('id', $id)->delete();

        Alert::error('Successfully done', '');
        return redirect()->back();
    }


    public function seo_slug($string)
    {
        
        $string=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
        $string=strtolower($string);
        return $string; 
    
    }
    

    
    public function img_slug($string)
    {
        
        $string=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
        $string=strtolower($string);
        return $string; 
    
    }
    
    
    public function non_seo_slug($string)
    {
        $string=str_replace(" ","-",$string);
        $string=strtolower($string);
        return $string; 
    
    }

}
