<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Continent;
use App\Models\UmrahService;
use App\Models\UmrahServiceImage;
use App\Models\UmrahServiceCountry;
use App\Models\Country;
use Alert;

class UmrahServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = UmrahService::orderBy('id', 'desc')->get();
        return view('admin.umrah_service.index', compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $continents = Continent::where('status', 1)->get();
        return view('admin.umrah_service.create', compact('continents'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'continent_id' => 'required',
            'title' => 'required',
            'price_start_per_person' => 'required',
            'expire_date' => 'required',
        ]);

        $data = new UmrahService();
        $data->continent_id = $request->continent_id;
        $data->title = $request->title;
        $data->slug = $this->seo_slug($request->title);
        $data->expire_date = $request->expire_date;
        $data->price_start_per_person = $request->price_start_per_person;
        $data->umrah_details = $request->umrah_details;
        $data->umrah_other_information = $request->umrah_other_information;
        $data->umrah_faq = $request->umrah_faq;
        $data->umrah_remark = $request->umrah_remark;
        $data->umrah_itinerary = $request->umrah_itinerary;
        $data->best_umrah_service_for = $request->best_umrah_service_for;
        $data->meta_title = $request->meta_title;
        $data->meta_description = $request->meta_description;
        $data->meta_keywords = $request->meta_keywords;

        $meta_image = $request->file('meta_image');
        if($meta_image)
        {
            $image_name= time().'_'.$meta_image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/umrah_service_meta_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $meta_image->move($upload_path, $image_full_name);
            if($success)
            {
                $data->meta_image = $image_url;
            }
        }

        $data->status = $request->status;
        $data->save();


        $country_id = $request->country_id;

        if($country_id){

            foreach ($country_id as $key => $value ){
                $umrah_image = new UmrahServiceCountry();
                $umrah_image->umrah_service_id = $data->id;
                $umrah_image->country_id = $value;
                $umrah_image->save();
            }

        }



        $file = $request->file('image');

        if($file){

            foreach ($file as $key => $value ){
                $umrah_image = new UmrahServiceImage();
                $image_name=time().$data->id.'_'.$value->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/umrah_service_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $value->move($upload_path, $image_full_name);
                $umrah_image->umrah_service_id = $data->id;
                $umrah_image->image = $image_url;
                $umrah_image->save();
            }

        }


        Alert::success('Successfully done', '');
        return redirect()->back();
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $data = UmrahService::find($id);
        $umrah_service_images = UmrahServiceImage::where('umrah_service_id', $id)->get();

        $continents = Continent::where('status', 1)->get();
        $countries = Country::where('continent_id', $data->continent_id)->where('status', 1)->get();

        $umrah_countries = UmrahServiceCountry::where('umrah_service_id', $id)->get();

        return view('admin.umrah_service.edit', compact('continents', 'data', 'umrah_service_images', 'countries', 'umrah_countries'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = UmrahService::find($id);
        $data->continent_id = $request->continent_id;
        $data->title = $request->title;
        $data->slug = $this->seo_slug($request->title);
        $data->expire_date = $request->expire_date;
        $data->price_start_per_person = $request->price_start_per_person;
        $data->umrah_details = $request->umrah_details;
        $data->umrah_other_information = $request->umrah_other_information;
        $data->umrah_faq = $request->umrah_faq;
        $data->umrah_remark = $request->umrah_remark;
        $data->umrah_itinerary = $request->umrah_itinerary;
        $data->best_umrah_service_for = $request->best_umrah_service_for;
        $data->meta_title = $request->meta_title;
        $data->meta_description = $request->meta_description;
        $data->meta_keywords = $request->meta_keywords;

        $meta_image = $request->file('meta_image');
        if($meta_image)
        {
            $image_name= time().'_'.$meta_image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/umrah_service_meta_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $meta_image->move($upload_path, $image_full_name);
            if($success)
            {

                $old_meta_image = $request->old_meta_image;
                if (file_exists($old_meta_image)) {
                    unlink($request->old_meta_image);
                }


                $data->meta_image = $image_url;
            }
        }

        $data->status = $request->status;
        $data->save();



        $country_id = $request->country_id;
        if($country_id){
            UmrahServiceCountry::where('umrah_service_id', $id)->delete();

            foreach ($country_id as $key => $value ){
                $umrah_image = new UmrahServiceCountry();
                $umrah_image->umrah_service_id = $data->id;
                $umrah_image->country_id = $value;
                $umrah_image->save();
            }

        }


        $file = $request->file('image');
        if($file){

            // $umrah_service_images = UmrahServiceImage::select('image')->where('umrah_service_id', $id)->get();
            // foreach ($umrah_service_images as $key => $value) {
            //     unlink($value->image);
            // }

            foreach ($file as $key => $value ){

                $umrah_image = new UmrahServiceImage();
                $image_name=time().$data->id.'_'.$value->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/umrah_service_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $value->move($upload_path, $image_full_name);
                $umrah_image->umrah_service_id = $data->id;
                $umrah_image->image = $image_url;
                $umrah_image->save();

            }

        }


        Alert::success('Successfully done', '');
        return redirect()->back();
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $umrah_service = UmrahService::where('id', $id)->first();

        $filePath = $umrah_service->image;

        if (file_exists($filePath)) {
            unlink($filePath);
        }


        $umrah_service_images = UmrahServiceImage::select('image')->where('umrah_service_id', $id)->get();

        if(count($umrah_service_images) > 0){

            foreach ($umrah_service_images as $key => $value) {
                unlink($value->image);
            }

        }

        UmrahServiceCountry::where('umrah_service_id', $id)->delete();

        UmrahService::where('id', $id)->delete();


        Alert::error('Successfully done', '');
        return redirect()->back();
    }

    public function delete_umrah_service_image($id)
    {
        $imagePath = UmrahServiceImage::select('image')->where('id', $id)->first();

        $filePath = $imagePath->image;

        if (file_exists($filePath)) {
            unlink($filePath);
        }

        UmrahServiceImage::where('id', $id)->delete();

        Alert::error('Successfully done', '');
        return redirect()->back();
    }


    public function seo_slug($string)
    {
        
        $string=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
        $string=strtolower($string);
        return $string; 
    
    }
    

    
    public function img_slug($string)
    {
        
        $string=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
        $string=strtolower($string);
        return $string; 
    
    }
    
    
    public function non_seo_slug($string)
    {
        $string=str_replace(" ","-",$string);
        $string=strtolower($string);
        return $string; 
    
    }

}
