<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\WebsiteInformation;
use Alert;

class WebsiteInformationController extends Controller
{

    public function index()
    {
        $data = WebsiteInformation::first();
        return view('admin.website_information.index', compact('data'));
    }


    public function store(Request $request)
    {
        $info = WebsiteInformation::first();

        if($info){

            $data = WebsiteInformation::find($info->id);
            $data->name = $request->name;
            $data->phone_number = $request->phone_number;
            $data->email = $request->email;
            $data->address = $request->address;
            $data->short_description = $request->short_description;
            $data->google_map_address = $request->google_map_address;
            $data->google_map_embed = $request->google_map_embed;


            $data->facebook = $request->facebook;
            $data->twitter = $request->twitter;
            $data->whatsapp = $request->whatsapp;
            $data->linkedin = $request->linkedin;
            $data->instagram = $request->instagram;
            $data->youtube = $request->youtube;


            $data->meta_title = $request->meta_title;
            $data->meta_keywords = $request->meta_keywords;
            $data->meta_description = $request->meta_description;


            $logo_light = $request->file('logo_light');
            if($logo_light)
            {
                $image_name= time().'_'.$logo_light->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/website_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $logo_light->move($upload_path, $image_full_name);
                if($success)
                {

                    $old_logo_light = $request->old_logo_light;
                    if (file_exists($old_logo_light)) {
                        unlink($request->old_logo_light);
                    }

                    $data->logo_light = $image_url;
                }
            }


            $logo_dark = $request->file('logo_dark');
            if($logo_dark)
            {
                $image_name= time().'_'.$logo_dark->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/website_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $logo_dark->move($upload_path, $image_full_name);
                if($success)
                {

                    $old_logo_dark = $request->old_logo_dark;
                    if (file_exists($old_logo_dark)) {
                        unlink($request->old_logo_dark);
                    }

                    $data->logo_dark = $image_url;
                }
            }


            $fav_icon = $request->file('fav_icon');
            if($fav_icon)
            {
                $image_name= time().'_'.$fav_icon->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/website_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $fav_icon->move($upload_path, $image_full_name);
                if($success)
                {

                    $old_fav_icon = $request->old_fav_icon;
                    if (file_exists($old_fav_icon)) {
                        unlink($request->old_fav_icon);
                    }

                    $data->fav_icon = $image_url;
                }
            }


            $meta_image = $request->file('meta_image');
            if($meta_image)
            {
                $image_name= time().'_'.$meta_image->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/website_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $meta_image->move($upload_path, $image_full_name);
                if($success)
                {

                    $old_meta_image = $request->old_meta_image;
                    if (file_exists($old_meta_image)) {
                        unlink($request->old_meta_image);
                    }

                    $data->meta_image = $image_url;
                }
            }

            $data->save();

        }else{

            $data = new WebsiteInformation();
            $data->name = $request->name;
            $data->phone_number = $request->phone_number;
            $data->email = $request->email;
            $data->address = $request->address;
            $data->short_description = $request->short_description;
            $data->google_map_address = $request->google_map_address;
            $data->google_map_embed = $request->google_map_embed;


            $data->facebook = $request->facebook;
            $data->twitter = $request->twitter;
            $data->whatsapp = $request->whatsapp;
            $data->linkedin = $request->linkedin;
            $data->instagram = $request->instagram;
            $data->youtube = $request->youtube;


            $data->meta_title = $request->meta_title;
            $data->meta_keywords = $request->meta_keywords;
            $data->meta_description = $request->meta_description;


            $logo_light = $request->file('logo_light');
            if($logo_light)
            {
                $image_name= time().'_'.$logo_light->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/website_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $logo_light->move($upload_path, $image_full_name);
                if($success)
                {
                    $data->logo_light = $image_url;
                }
            }


            $logo_dark = $request->file('logo_dark');
            if($logo_dark)
            {
                $image_name= time().'_'.$logo_dark->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/website_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $logo_dark->move($upload_path, $image_full_name);
                if($success)
                {
                    $data->logo_dark = $image_url;
                }
            }


            $fav_icon = $request->file('fav_icon');
            if($fav_icon)
            {
                $image_name= time().'_'.$fav_icon->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/website_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $fav_icon->move($upload_path, $image_full_name);
                if($success)
                {
                    $data->fav_icon = $image_url;
                }
            }


            $meta_image = $request->file('meta_image');
            if($meta_image)
            {
                $image_name= time().'_'.$meta_image->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/website_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $meta_image->move($upload_path, $image_full_name);
                if($success)
                {
                    $data->meta_image = $image_url;
                }
            }

            $data->save();

        }

        Alert::success('Successfully done', '');
        return redirect()->back();


    }


}
