<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Country;
use App\Models\UmrahService;
use App\Models\Continent;
use App\Models\TourService;
use App\Models\TourServiceCountry;
use App\Models\Blog;
use App\Models\Category;
use App\Models\VisaService;
use Auth;
use DB;


class AjaxController extends Controller
{


    public function get_country(Request $request)
    {
        $datas = Country::where('continent_id', $request->continent_id)->get();
        return view('ajax_request.get_country', compact('datas'));
    }

    public function get_blogs(Request $request)
    {
        $blogs = Blog::orderBy('id', 'desc')->where('status', 1)->paginate(7);
        $categories = Category::where('status', 1)->get();


        $tour_packages = TourService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();
        $visa_services = VisaService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();
        $umrah_services = UmrahService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();

        return view('ajax_request.get_blogs', compact('blogs', 'tour_packages', 'visa_services', 'umrah_services', 'categories'));
    }

    public function get_umrah_packages(Request $request)
    {
        $umrah_services = UmrahService::where('status',1)->orderBy('id', 'desc')->get();
        return view('ajax_request.get_umrah_packages', compact('umrah_services'));
    }

    public function get_tour_packages(Request $request)
    {
        $continents = Continent::where('status', 1)->get();
        $multi_country_tours = TourService::where('status',1)->orderBy('id', 'desc')->get();

        return view('ajax_request.get_tour_packages', compact('multi_country_tours', 'continents'));
    }

    public function get_visa_packages(Request $request)
    {
        $continents = Continent::where('status', 1)->get();
        $tour_services = TourService::where('status',1)->orderBy('id', 'desc')->get();

        return view('ajax_request.get_visa_packages', compact('tour_services', 'continents'));
    }

    public function get_country_wsie_tour_packages(Request $request)
    {
        $continents = Continent::where('status', 1)->get();

        $country_id = $request->country_id;

        $tour_service_countries = TourServiceCountry::where('country_id', $country_id)->orderBy('id', 'desc')->get();

        $continents = Continent::where('status', 1)->get();
        $multi_country_tours = TourService::where('status',1)->orderBy('id', 'desc')->get();

        return view('ajax_request.get_country_wsie_tour_packages', compact('tour_service_countries', 'continents', 'multi_country_tours', 'continents'));
    }





}
