<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\WebsiteInformation;
use App\Models\Banner;
use App\Models\ProgramCategory;
use App\Models\OtherService;
use App\Models\Course;
use App\Models\FAQ;
use App\Models\Contact;
use App\Models\HomePageSetting;
use App\Models\Aboutus;
use App\Models\UmrahService;
use App\Models\PageDiscription;
use App\Models\UmrahServiceImage;
use App\Models\UmrahServiceCountry;
use App\Models\TourService;
use App\Models\VisaService;
use App\Models\Country;
use App\Models\Continent;
use App\Models\TourServiceCountry;
use App\Models\TourServiceImage;
use App\Models\VisaServiceImage;
use App\Models\Blog;
use App\Models\Category;
use App\Models\GuestQuestion;
use App\Models\GuestRequest;
use App\Models\Subscription;
use App\Models\Page;
use Alert;

class HomeController extends Controller
{
    public function welcome()
    {
        $site_info = WebsiteInformation::first();
        $other_services = OtherService::where('status', 1)->get();
        $banners = Banner::where('status', 1)->get();

        $home_page_setting = HomePageSetting::first();
        $host = request()->getHttpHost();

        $countries = Country::where('status', 1)->get();

        return view('welcome', compact('site_info', 'other_services', 'banners', 'home_page_setting', 'host', 'countries'));
    }

    public function about_us()
    {
        $site_info = WebsiteInformation::first();
        $host = request()->getHttpHost();

        $about_us = Aboutus::first();
        return view('frontend.pages.about_us', compact('site_info', 'about_us', 'host'));

    }

    public function messege_from_ceo()
    {
        $site_info = WebsiteInformation::first();
        $host = request()->getHttpHost();

        $about_us = Aboutus::first();
        return view('frontend.pages.messege_from_ceo', compact('site_info', 'about_us', 'host'));

    }


    public function umrah_packages_from_bangladesh()
    {
        $site_info = WebsiteInformation::first();
        $host = request()->getHttpHost();

        $umrah_services = UmrahService::where('status',1)->orderBy('id', 'desc')->get();
        $page_des = PageDiscription::first();

        return view('frontend.pages.umrah_packages_from_bangladesh', compact('site_info', 'umrah_services', 'host', 'page_des'));

    }

    public function umrah_package_details($id, $slug)
    {

        $site_info = WebsiteInformation::first();
        $host = request()->getHttpHost();

        $umrah_package = UmrahService::where('id', $id)->where('slug', $slug)->first();
        $umrah_package_images = UmrahServiceImage::where('umrah_service_id', $umrah_package->id)->get();
        $umrah_countries = UmrahServiceCountry::where('umrah_service_id', $umrah_package->id)->get();

        $other_umrah_packages = UmrahService::whereNotIn('id', [$id])->orderBy('id', 'desc')->take(5)->where('status', 1)->get();

        $tour_packages = TourService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();
        $visa_services = VisaService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();
        $countries = Country::orderBy('id', 'desc')->take(5)->where('status', 1)->get();


        return view('frontend.pages.umrah_package_details', compact('site_info', 'umrah_package', 'host', 'umrah_package_images', 'umrah_countries', 'other_umrah_packages', 'tour_packages', 'visa_services', 'countries'));

    }

    public function holiday_packages_from_bangladesh()
    {

        $site_info = WebsiteInformation::first();
        $host = request()->getHttpHost();

        $page_des = PageDiscription::first();
        $continents = Continent::where('status', 1)->get();


        $tour_services = TourService::where('status',1)->orderBy('id', 'desc')->get();

        return view('frontend.pages.holiday_packages_from_bangladesh', compact('site_info', 'tour_services', 'host', 'page_des', 'continents'));

    }

    public function tour_packages($slug)
    {

        $site_info = WebsiteInformation::first();
        $host = request()->getHttpHost();

        $country = Country::where('slug', $slug)->first();
        $tour_service_countries = TourServiceCountry::where('country_id', $country->id)->orderBy('id', 'desc')->get();

        $continents = Continent::where('status', 1)->get();
        $multi_country_tours = TourService::where('status',1)->orderBy('id', 'desc')->get();

        return view('frontend.pages.tour_packages', compact('site_info', 'host', 'country', 'tour_service_countries', 'continents', 'multi_country_tours'));

    }
    

    public function tour_package_details($id, $slug)
    {

        $site_info = WebsiteInformation::first();
        $host = request()->getHttpHost();

        $tour_package = TourService::where('id', $id)->where('slug', $slug)->first();
        $tour_package_images = TourServiceImage::where('tour_service_id', $tour_package->id)->get();
        $tour_countries = TourServiceCountry::where('tour_service_id', $tour_package->id)->get();

        $other_tour_packages = TourService::whereNotIn('id', [$id])->orderBy('id', 'desc')->take(5)->where('status', 1)->get();

        $umrah_services = UmrahService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();
        $visa_services = VisaService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();
        $countries = Country::orderBy('id', 'desc')->take(5)->where('status', 1)->get();


        return view('frontend.pages.tour_package_details', compact('site_info', 'tour_package', 'host', 'tour_package_images', 'tour_countries', 'other_tour_packages', 'umrah_services', 'visa_services', 'countries'));

    }



    public function visa_processing_agent_bangladesh()
    {

        $site_info = WebsiteInformation::first();
        $host = request()->getHttpHost();

        $page_des = PageDiscription::first();
        $continents = Continent::where('status', 1)->get();


        $tour_services = TourService::where('status',1)->orderBy('id', 'desc')->get();


        return view('frontend.pages.visa_processing_agent_bangladesh', compact('site_info', 'tour_services', 'host', 'page_des', 'continents'));

    }

    public function visa($slug)
    {

        $site_info = WebsiteInformation::first();
        $host = request()->getHttpHost();

        $continents = Continent::where('status', 1)->get();

        $country = Country::where('slug', $slug)->first();

        $visa_service = VisaService::where('country_id', $country->id)->first();
        $visa_service_images = VisaServiceImage::where('visa_service_id', $visa_service->id)->get();


        $other_visa_services = VisaService::whereNotIn('id', [$visa_service->country_id])->orderBy('id', 'desc')->take(5)->where('status', 1)->get();


        $umrah_services = UmrahService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();
        $countries = Country::orderBy('id', 'desc')->take(5)->where('status', 1)->get();
        $tour_packages = TourService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();


        return view('frontend.pages.visa_details', compact('site_info', 'visa_service', 'host', 'continents', 'country', 'other_visa_services', 'umrah_services', 'countries', 'visa_service_images', 'tour_packages'));

    }

    public function blogs()
    {
        $site_info = WebsiteInformation::first();
        $host = request()->getHttpHost();

        $blogs = Blog::orderBy('id', 'desc')->where('status', 1)->paginate(7);
        $categories = Category::where('status', 1)->get();


        $tour_packages = TourService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();
        $visa_services = VisaService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();
        $umrah_services = UmrahService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();

        return view('frontend.pages.blogs', compact('site_info', 'host', 'blogs', 'tour_packages', 'visa_services', 'umrah_services', 'categories'));
    }

    public function category_wise_blogs($id, $slug)
    {
        $site_info = WebsiteInformation::first();
        $host = request()->getHttpHost();

        $category = Category::where('id', $id)->where('slug', $slug)->first();

        $blogs = Blog::orderBy('id', 'desc')->where('category_id', $category->id)->where('status', 1)->paginate(7);
        $categories = Category::where('status', 1)->get();


        $tour_packages = TourService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();
        $visa_services = VisaService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();
        $umrah_services = UmrahService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();

        return view('frontend.pages.category_wise_blogs', compact('site_info', 'host', 'blogs', 'tour_packages', 'visa_services', 'umrah_services', 'categories', 'category'));
    }

    public function blog_details($id, $slug)
    {
        $site_info = WebsiteInformation::first();
        $host = request()->getHttpHost();

        $blog = Blog::where('id', $id)->where('slug', $slug)->first();
        $recent_posts = Blog::orderBy('id', 'desc')->take(5)->where('status', 1)->get();

        $categories = Category::where('status', 1)->get();
        $tour_packages = TourService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();
        $visa_services = VisaService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();
        $umrah_services = UmrahService::orderBy('id', 'desc')->take(5)->where('status', 1)->get();

        return view('frontend.pages.blog_details', compact('site_info', 'host', 'blog', 'tour_packages', 'visa_services', 'umrah_services', 'categories', 'recent_posts'));

    }




    public function contact()
    {
        $site_info = WebsiteInformation::first();
        $host = request()->getHttpHost();
        $page_des = PageDiscription::first();

        return view('frontend.pages.contact', compact('site_info', 'host', 'page_des'));
    }

    public function submit_message(Request $request)
    {
        $validatedData = $request->validate([
            'full_name' => ['required', 'max:255'],
            'phone_number' => ['required', 'max:11'],
            'message' => ['required'],
        ]);

        $data = new Contact();
        $data->full_name = $request->full_name;
        $data->phone_number = $request->phone_number;
        $data->message = $request->message;
        $data->status = 0;
        $data->save();

        Alert::success('Your message submitted successfull', '');
        return redirect()->back();

    }


    public function submit_question_faq(Request $request)
    {
        $validatedData = $request->validate([
            'type' => ['required'],
            'full_name' => ['required'],
            'phone_number' => ['required'],
            'email_address' => ['required'],
            'question' => ['required'],
        ]);

        $data = new GuestQuestion();
        $data->type = $request->type;
        $data->full_name = $request->full_name;
        $data->phone_number = $request->phone_number;
        $data->email_address = $request->email_address;
        $data->question = $request->question;
        $data->status = 0;
        $data->save();

        Alert::success('Your message submitted successfull', '');
        return redirect()->back();

    }

    public function send_tour_request(Request $request)
    {
        $validatedData = $request->validate([
            'type' => ['required'],
            'want_to_go_country_id' => ['required'],
            'nationality_country_id' => ['required'],
            'phone_number' => ['required'],
            'email_address' => ['required'],
        ]);

        $data = new GuestRequest();
        $data->type = $request->type;
        $data->want_to_go_country_id = $request->want_to_go_country_id;
        $data->nationality_country_id = $request->nationality_country_id;
        $data->phone_number = $request->phone_number;
        $data->email_address = $request->email_address;
        $data->status = 0;
        $data->save();

        Alert::success('Your request submitted successfull', '');
        return redirect('/request');

    }


    public function send_visa_request(Request $request)
    {
        $validatedData = $request->validate([
            'type' => ['required'],
            'want_to_go_country_id' => ['required'],
            'nationality_country_id' => ['required'],
            'phone_number' => ['required'],
            'email_address' => ['required'],
        ]);

        $data = new GuestRequest();
        $data->type = $request->type;
        $data->want_to_go_country_id = $request->want_to_go_country_id;
        $data->nationality_country_id = $request->nationality_country_id;
        $data->phone_number = $request->phone_number;
        $data->email_address = $request->email_address;
        $data->status = 0;
        $data->save();

        Alert::success('Your request submitted successfull', '');
        return redirect('/request');

    }

    public function request()
    {
        $site_info = WebsiteInformation::first();
        $host = request()->getHttpHost();
        return view('frontend.pages.request', compact('site_info', 'host'));
    }

    public function page($slug)
    {
        $data = Page::where('slug', $slug)->first();
        $host = request()->getHttpHost();
        return view('frontend.pages.page_details', compact('data', 'host'));

    }



    //ajax data
    public function get_banner(Request $request)
    {
        $banners = Banner::where('status', 1)->get();
        $countries = Country::where('status', 1)->get();
        return view('frontend.components.slider', compact('banners', 'countries'));
    }

    public function get_course(Request $request)
    {
        $courses = Course::where('status', 1)->orderBy('id', 'desc')->get();
        return view('frontend.components.course', compact('courses'));
    }

    public function subscription(Request $request)
    {
        $validatedData = $request->validate([
            'email' => ['required'],
        ]);

        $already = Subscription::where('email', $request->email)->first();
        if($already){
            Alert::success('Thanks', 'You already subscribed !');
            return redirect()->back();
        }

        $data = new Subscription();
        $data->email = $request->email;
        $data->status = 0;
        $data->save();

        Alert::success('Your subscription successfull', '');
        return redirect()->back();
    }

}
