<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_id');
            $table->string('name');
            $table->string('phone_number');
            $table->string('product_id');
            $table->string('color_id')->nullable();
            $table->decimal('unit_price', 10,2);
            $table->string('quantity');
            $table->decimal('shipping_charge',10,2);
            $table->decimal('discount',10,2);
            $table->decimal('advance',10,2)->nullable();
            $table->decimal('cash_collection',10,2)->nullable();
            $table->decimal('total',10,2);
            $table->string('district');
            $table->text('devlivery_address');
            $table->string('payment_method')->default('Cash on delivery');
            $table->integer('payment_status')->default(0);
            $table->integer('status')->default(0);
            $table->integer('pending_status')->default(1);
            $table->integer('confirm_status')->default(0);
            $table->integer('reject_status')->default(0);
            $table->integer('processing_status')->default(0);
            $table->integer('in_transit_status')->default(0);
            $table->integer('delivered_status')->default(0);
            $table->integer('canceled_status')->default(0);
            $table->text('note')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
