<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTourServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tour_services', function (Blueprint $table) {
            $table->id();
            $table->integer('continent_id');
            $table->text('title');
            $table->text('slug');
            $table->integer('price_start_per_person');
            $table->longText('tour_details')->nullable();
            $table->longText('tour_other_information')->nullable();
            $table->longText('tour_faq')->nullable();
            $table->longText('tour_remark')->nullable();
            $table->longText('tour_itinerary')->nullable();
            $table->longText('best_tour_service_for')->nullable();
            $table->text('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('meta_keywords')->nullable();
            $table->text('meta_image')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tour_services');
    }
}
