@extends('admin.layouts.app')
@section('head')
<title>Edit blog | {{ config('app.name') }}  </title>
<meta name="csrf-token" content="{{csrf_token()}}">
@endsection
@section('content')



    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">blog</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">blog</a></li>
                                    <li class="breadcrumb-item active">Add blog</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div id="instructorList">

                  

                    <div class="row">
                        <div class="col-lg-2"></div>
                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row align-items-center g-2">
                                        <div class="col-lg-3 me-auto">
                                            <h6 class="card-title mb-0">Edit blog </h6>
                                        </div><!--end col-->
                             
                                        <div class="col-sm-auto">
                                            <div class="hstack gap-2">

                                                <a href="#" data-bs-toggle="modal" class="btn btn-secondary"><i class="bi bi-plus-circle align-baseline me-1"></i> Edit blog</a>

                                            </div>
                                        </div><!--end col-->
                                    </div>
                                </div>
                                <div class="card-body mt-3">

                                    @if ($errors->any())

                                        <div class="alert alert-danger">

                                            <ul>

                                                @foreach ($errors->all() as $error)

                                                    <li>{{ $error }}</li>

                                                @endforeach

                                            </ul>

                                        </div>

                                    @endif



                                      <form class="form-horizontal" action="{{URL::to('admin/blog/'.$data->id)}}" method="post" enctype="multipart/form-data">



                                        @csrf

                                        @method('PATCH')


                                            <div class="modal-body">
                                                <div id="alert-error-msg" class="d-none alert alert-danger py-2"></div>
                                                <input type="hidden" id="id-field">
                                                <input type="hidden" id="rating-field">
                                              
                            
                                                <div class="row">
                                                    

                                                    <div class="col-lg-12">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label"> Category<span class="text-danger">*</span></label>
                                                            <select class="form-control" name="category_id" required>
                                                                <option value="">Select</option>

                                                                @foreach($categories as $item)
                                                                <option value="{{$item->id}}" @php if ($item->id == $data->category_id) { echo "selected"; } @endphp>{{$item->name}}</option>
                                                                @endforeach

                                                            </select>
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-12">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Title<span class="text-danger">*</span></label>
                                                            <input type="text" id="instructor-name-input" name="title"value="{{ $data->title }}" class="form-control" placeholder="Enter Title" required>
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label"> Image </label>
                                                            <input type="file" id="instructor-name-input" name="image" class="form-control">


                                                            @if(isset($data->image))
                                                            <div class="form-group">
                                                                <a href="{{ asset($data->image) }}" target="_blank"><img src="{{ asset($data->image) }}" alt="Image" style="width: 100px; margin-top: 8px"></a>
                                                                <input type="hidden" name="old_image" value="{{ $data->image }}">
                                                            </div>
                                                            @endif

                                                        </div>
                                                    </div>


                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label"> Cover Image </label>
                                                            <input type="file" id="instructor-name-input" name="cover_image" class="form-control">

                                                            @if(isset($data->cover_image))
                                                            <div class="form-group">
                                                                <a href="{{ asset($data->cover_image) }}" target="_blank"><img src="{{ asset($data->cover_image) }}" alt="cover_image" style="width: 100px; margin-top: 8px"></a>
                                                                <input type="hidden" name="old_cover_image" value="{{ $data->cover_image }}">
                                                            </div>
                                                            @endif

                                                        </div>
                                                    </div>


                                                    <div class="col-lg-12">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Description<span class="text-danger">*</span></label>
                                                            <textarea name="blog_description" class="form-control" id="" cols="30" rows="10" required>{!! $data->blog_description !!}</textarea>

                                                            <script>
                                                                CKEDITOR.replace('blog_description', {

                                                                    filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",

                                                                    filebrowserUploadMethod: 'form'

                                                                });

                                                                CKEDITOR.instances['blog_description'].setData({!! json_encode($data->blog_description ?? '') !!})
                                                             </script>

                                                        </div>
                                                    </div>



                                                    <div class="col-lg-12">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Meta Title</label>
                                                            <input type="text" id="instructor-name-input" name="meta_title" value="{{ $data->meta_title }}" class="form-control" placeholder="Enter Meta Title" >
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-12">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Meta Description</label>
                                                            <input type="text" id="instructor-name-input" name="meta_description" value="{{ $data->meta_description }}" class="form-control" placeholder="Enter Meta Description" required>
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-12">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Meta Keywords</label>
                                                            <input type="text" id="instructor-name-input" name="meta_keywords" value="{{ $data->meta_keywords }}" class="form-control" placeholder="Enter Meta Keywords" >
                                                        </div>
                                                    </div>

                                                 

                                                    <div class="col-lg-12">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Status<span class="text-danger">*</span></label>
                                                            <select class="form-control" name="status" required>
                                                                <option value="1" @php echo $data->status==1?"selected":""; @endphp>Active</option>
                                                                <option value="0" @php echo $data->status==0?"selected":""; @endphp>Inactive</option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                 
                                                  
                                                </div><!--end row-->
                                            </div>
                                            <div class="modal-footer">
                                                <div class="hstack gap-2 justify-content-end">
                                                    <button type="button" class="btn btn-ghost-danger" data-bs-dismiss="modal"><i class="bi bi-x-lg align-baseline me-1"></i> Close</button>
                                                    <button type="submit" class="btn btn-primary" id="add-btn">Update</button>
                                                </div>
                                            </div>
                                        </form>
                          
                                </div>
                            </div>
                        </div><!--end col-->
                        <div class="col-lg-2"></div>
                    </div><!--end row-->

                </div>

            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->

    </div>


@endsection