@extends('admin.layouts.app')

@section('head')
<title> Manage quest question | {{ config('app.name') }}  </title>
<meta name="csrf-token" content="{{csrf_token()}}">
@endsection

@section('content')

        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <h4 class="mb-sm-0">quest question</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">quest question</a></li>
                                        <li class="breadcrumb-item active">List View</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div id="instructorList">

                      
    
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row align-items-center g-2">
                                            <div class="col-lg-3 me-auto">
                                                <h6 class="card-title mb-0">quest question List<span class="badge bg-primary ms-1 align-baseline"> {{ $datas->count() }} </span></h6>
                                            </div><!--end col-->
                                    
                                            <div class="col-sm-auto">
                                                <div class="hstack gap-2">
                                                

                                                </div>
                                            </div><!--end col-->
                                        </div>
                                    </div>
                                    <div class="card-body mt-3">
                                        <div class="table-responsive table-card">
                                            <table id="myTable" class="table table-centered align-middle table-custom-effect table-nowrap mb-0">
                                                <thead class="table-light">
                                                    <tr>
                                                       
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor_id">SL</th>
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor"> TYPE </th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor"> NAME</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor"> PHONE NUMBER</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor"> EMAIL</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor"> QUESTION</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor"> STATUS</th> 
                                                                                              
                                                        <th scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="list form-check-all">

                                                	@php $i = 1 @endphp
                                                	@foreach($datas as $item)
                                                    <tr>
                                                      
                                                       
                                                        <td class="courses_total">{{ $i++ }}</td>
                                                        <td class="courses_total">{{ $item->type ?? '' }}</td>
                                                        <td class="courses_total">{{ $item->full_name ?? '' }}</td>
                                                        <td class="courses_total">{{ $item->phone_number }}</td>
                                                        <td class="courses_total">{{ $item->email_address }}</td>
                                                        <td class="courses_total">{{ $item->question }}</td>

                                                        <td class="courses_total">
                                                                
                                                            @if($item->status == 1)

                                                                <span class="badge bg-success">COMPELETE</span>

                                                            @else

                                                                <span class="badge bg-danger">PENDING</span>

                                                            @endif

                                                        </td>

                                                       
                                                       
                                                        <td>
                                                            <ul class="d-flex gap-2 list-unstyled mb-0">
                                                              
                                                                <li>
                                                                    <a href="{{URL::to('admin/guest_question/'.$item->id.'/edit')}}"  class="btn btn-subtle-secondary btn-icon btn-sm edit-item-btn"><i class="ph-pencil"></i></a>
                                                                </li>
                                                                <li>

											                        <form action="{{URL::to('admin/guest_question/'.$item->id)}}" method="post">

											                          @csrf

											                          @method('DELETE')

											                          <button  class="btn btn-subtle-danger btn-icon btn-sm remove-item-btn" type="submit">
											                          	<i class="ph-trash"></i>
											                          	</button>

											                        </form>

                                                                </li>
                                                            </ul>
                                                        </td>
                                                    </tr>
                                                    @endforeach

                                                </tbody><!-- end tbody -->
                                            </table><!-- end table -->
                                    
                                        </div>
                              
                                    </div>
                                </div>
                            </div><!--end col-->
                        </div><!--end row-->

                    </div>

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

        </div>






@stop