@extends('admin.layouts.app')

@section('head')
<title> Add page | {{ config('app.name') }}  </title>
<meta name="csrf-token" content="{{csrf_token()}}">
@endsection

@section('content')

        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <h4 class="mb-sm-0">page</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">page</a></li>
                                        <li class="breadcrumb-item active">Add page</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div id="instructorList">

                      
    
                        <div class="row">
                            <div class="col-lg-2"></div>
                            <div class="col-lg-8">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row align-items-center g-2">
                                            <div class="col-lg-3 me-auto">
                                                <h6 class="card-title mb-0">Add page </h6>
                                            </div><!--end col-->
                                 
                                            <div class="col-sm-auto">
                                                <div class="hstack gap-2">

                                                    <a href="{{route('page.index')}}" class="btn btn-secondary"><i class="bi bi-list align-baseline me-1"></i> Manage page</a>
                                                </div>
                                            </div><!--end col-->
                                        </div>
                                    </div>
                                    <div class="card-body mt-3">

                                    @if ($errors->any())

                                        <div class="alert alert-danger">

                                            <ul>

                                                @foreach ($errors->all() as $error)

                                                    <li>{{ $error }}</li>

                                                @endforeach

                                            </ul>

                                        </div>

                                    @endif

                                        <form action="{{route('page.store')}}" method="post">
                          
                                            @csrf
                        


                                                <div class="modal-body">
                                                    <div id="alert-error-msg" class="d-none alert alert-danger py-2"></div>
                                                    <input type="hidden" id="id-field">
                                                    <input type="hidden" id="rating-field">
                                                  
                                
                                                    <div class="row">
                                                        

                                                        <div class="col-lg-12" style="display: none;">
                                                            <div class="mb-3">
                                                                <label for="instructor-name-input" class="form-label">Page Category<span class="text-danger">*</span></label>
                                                                <select class="form-control" name="page_category_id" required>

                                                                    @foreach($page_categories as $item)
                                                                    <option value="{{$item->id}}">{{$item->name}}</option>
                                                                    @endforeach

                                                                </select>
                                                            </div>
                                                        </div>


                                                        <div class="col-lg-12">
                                                            <div class="mb-3">
                                                                <label for="instructor-name-input" class="form-label"> Title<span class="text-danger">*</span></label>
                                                                <input type="text" id="instructor-name-input" name="title" class="form-control" placeholder="Enter  title" required>
                                                            </div>
                                                        </div>


                                                        <div class="col-lg-12">
                                                            <div class="mb-3">
                                                                <label for="instructor-name-input" class="form-label">Description<span class="text-danger">*</span></label>
                                                                <textarea name="page_description" class="form-control" id="" cols="30" rows="10" required></textarea>

                                                                <script>
                                                                    CKEDITOR.replace('page_description', {

                                                                        filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",

                                                                        filebrowserUploadMethod: 'form'

                                                                    });

                                                                    CKEDITOR.instances['page_description'].setData({!! json_encode($data->page_description ?? '') !!})
                                                                 </script>

                                                            </div>
                                                        </div>

                                                     

                                                        <div class="col-lg-12">
                                                            <div class="mb-3">
                                                                <label for="instructor-name-input" class="form-label">Status<span class="text-danger">*</span></label>
                                                                <select class="form-control" name="status" required>
                                                                    <option value="1">Active</option>
                                                                    <option value="0">Inactive</option>
                                                                </select>
                                                            </div>
                                                        </div>

                                                     

                                                  
                                                   
                                                      
                                                      
                                                    </div><!--end row-->
                                                </div>
                                                <div class="modal-footer">
                                                    <div class="hstack gap-2 justify-content-end">
                                                        <button type="button" class="btn btn-ghost-danger" data-bs-dismiss="modal"><i class="bi bi-x-lg align-baseline me-1"></i> Close</button>
                                                        <button type="submit" class="btn btn-primary" id="add-btn">Save</button>
                                                    </div>
                                                </div>
                                            </form>
                              
                                    </div>
                                </div>
                            </div><!--end col-->
                            <div class="col-lg-2"></div>
                        </div><!--end row-->

                    </div>

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

        </div>


@stop