    

    @include('frontend.components.country_menu')



    <section class="umrah-all-packages-section">
        <div class="container">
            <div class="row g-4">

                @forelse($tour_service_countries as $tour_service_country)

                    <?php
                        $tour_service = App\Models\TourService::where('id', $tour_service_country->tour_service_id)->first();
                        $tour_countries = App\Models\TourServiceCountry::where('tour_service_id', $tour_service->id)->get();

                    ?>

                    <div class="col-md-6 col-lg-4">
                        <div class="umrah-single-pakage">
                            <div>
                                <img src="{{asset($tour_service->meta_image)}}" alt="{{ $tour_service->title }}">
                            </div>
                            <div class="umrah-package-content">
                                <h5 class="mb-0">{{ $tour_service->title }}</h5>
                                <p>Starts from BDT {{ $tour_service->price_start_per_person ?? 0 }} /Per Person</p>

                                <div class="umrah-cart-badge">
                                    

                                    @foreach($tour_countries as $tour_country)

                                        <?php
                                            $colorCode = '#' . str_pad(dechex(random_int(0, 16777215)), 6, '0', STR_PAD_LEFT);
                                        ?>

                                        <span class="badge" style="background: {{ $colorCode }} !important;">{{ $tour_country->country->name ?? '' }}</span>

                                    @endforeach

                                    <span class="badge">Tour</span>

                                </div>

                                <div class="umra-package-details-btn">
                                    <a href="{{ route('/tour', ['id' => $tour_service->id, 'slug' => $tour_service->slug]) }}" class="text-uppercase" style="color: white;">See Details <i class="fa-solid fa-arrow-right"></i></a>
                                </div>
                            </div>

                        </div>
                    </div>
                 @empty

                    <div class="col-md-12 col-lg-12" style="text-align: center;">
                           
                        	<h5 style="color: red;" class=""> Sorry. No package found ! </h5>

                    </div>

                @endforelse

            </div>
        </div>
    </section>

