
    
    @include('frontend.components.country_menu')



    @foreach($continents as $continent)

        <?php
            $countries = App\Models\Country::where('continent_id', $continent->id)->where('status', 1)->get();
        ?>

        @if(count($countries) > 0)
        <div class="display-flag-section">
            <div class="container">
                <div class="display-flag-title">
                    <h3 class="text-uppercase">{{ $continent->name }}</h3>
                </div>
                <div class="asia-display-flag">
                    <div class="row g-4">

                        @foreach($countries as $country)
                            <div class="col-md-4 col-lg-3 col-sm-6">
                                <a href="{{ route('tour-packages', $country->slug) }}">
                                    <div class="flag-img">
                                        <img src="{{asset($country->image)}}" alt="{{ $country->name }}">
                                        <div class="flag-name">
                                            <p>{{ $country->name }}</p>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        @endforeach

                    </div>
                </div>
            </div>
        </div>
        @endif
    @endforeach


    <section class="umrah-all-packages-section">
        <div class="container">
            <div class="multi-country-tour-title">
                <h3 class="text-uppercase">Multi Country Tour -</h3>
            </div>
            <div class="row g-4">


                @foreach($multi_country_tours as $tour_service)

                    <?php
                        $tour_countries = App\Models\TourServiceCountry::where('tour_service_id', $tour_service->id)->get();
                    ?>

                    @if(count($tour_countries) > 1)
                        <div class="col-md-6 col-lg-4">
                            <div class="umrah-single-pakage">
                                <div>
                                    <img src="{{asset($tour_service->meta_image)}}" alt="{{ $tour_service->title }}">
                                </div>
                                <div class="umrah-package-content">
                                    <h5 class="mb-0">{{ $tour_service->title }}</h5>
                                    <p>Starts from BDT {{ $tour_service->price_start_per_person ?? 0 }} /Per Person</p>

                                    <div class="umrah-cart-badge">
                                        <span class="badge">Tour</span>
                                        @foreach($tour_countries as $tour_country)

	                                        <?php
	                                            $colorCode = '#' . str_pad(dechex(random_int(0, 16777215)), 6, '0', STR_PAD_LEFT);
	                                        ?>

                                            <span class="badge" style="background: {{ $colorCode }} !important;">{{ $tour_country->country->name ?? '' }}</span>

                                        @endforeach
                                    </div>

                                    <div class="umra-package-details-btn">
                                        <a href="{{ route('/tour', ['id' => $tour_service->id, 'slug' => $tour_service->slug]) }}" class="text-uppercase" style="color: white;">See Details <i class="fa-solid fa-arrow-right"></i></a>
                                    </div>
                                </div>

                            </div>
                        </div>
                    @endif
                @endforeach


            </div>
        </div>
    </section>
