    <section class="megamenu-section">
        <div class="container">
            <div class="megamenu-container">
                <nav class="navbar navbar-expand-lg megamenu-nav">
                      <!-- Toggle button -->
                      <button class="navbar-toggler px-0" type="button" data-mdb-toggle="collapse"
                        data-mdb-target="#navbarExampleOnHover" aria-controls="navbarExampleOnHover" aria-expanded="false"
                        aria-label="Toggle navigation">
                        <i class="fa-solid fa-bars"></i> 
                        <span>Show Content</span>
                      </button>
                  
                      <!-- Collapsible wrapper -->
                      <div class="collapse navbar-collapse megamenu-main-list" id="navbarExampleOnHover">
                        <!-- Left links -->
                        <ul class="navbar-nav me-auto ps-lg-0" style="padding-left: 0.15rem">
                          <!-- Navbar dropdown -->
                          @foreach($continents as $continent)
                          <?php
                                $countries = App\Models\Country::where('continent_id', $continent->id)->where('status', 1)->get();
                          ?>

                          @if(count($countries) > 0)
                          <li class="nav-item dropdown dropdown-hover position-static">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button"
                              data-mdb-toggle="dropdown" aria-expanded="false" style="text-transform: uppercase;">
                              {{ $continent->name }}
                            </a>



                            <!-- Dropdown menu -->
                            <div class="dropdown-menu w-100 mt-0" aria-labelledby="navbarDropdown" style="border-top-left-radius: 0; border-top-right-radius: 0;">
                  
                              <div class="container">
                                <div class="row my-4">

                                    @foreach($countries as $country)
                                      <div class="col-sm-6 col-md-4 col-lg-3 mb-3">
                                        <div class="asia-flag-container">
                                            <a href="{{ route('/visa', $country->slug) }}" target="_blank">
                                                <div class="d-flex asia-flag">
                                                    <div class="megamenu-flag">
                                                        <img src="{{asset($country->image)}}" alt="{{ $country->name }}">
                                                    </div>
                                                    <div>
                                                        <p>{{ $country->name }}</p>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                      </div>
                                    @endforeach
                                  
                        
                                  
                                </div>
                              </div>
                            </div>
                          </li>
                          @endif

                          @endforeach
                        </ul>
                        <!-- Left links -->
                      </div>
                      <!-- Collapsible wrapper -->
                  </nav>
            </div>
        </div>
    </section>


    @foreach($continents as $continent)

        <?php
            $visa_services = App\Models\VisaService::where('continent_id', $continent->id)->where('status', 1)->get();
        ?>

        @if(count($visa_services) > 0)
        <div class="display-flag-section">
            <div class="container">
                <div class="display-flag-title">
                    <h3 class="text-uppercase">{{ $continent->name }}</h3>
                </div>
                <div class="asia-display-flag">
                    <div class="row g-4">

                        @foreach($visa_services as $visa_service)
				
					        <?php
					            $country = App\Models\Country::where('id', $visa_service->country_id)->where('status', 1)->first();
					        ?>
                            <div class="col-md-4 col-lg-3 col-sm-6">
                                <a href="{{ route('/visa', $country->slug) }}">
                                    <div class="flag-img">
                                        <img src="{{asset($country->image)}}" alt="{{ $country->name }}">
                                        <div class="flag-name">
                                            <p>{{ $country->name }}</p>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        @endforeach

                    </div>
                </div>
            </div>
        </div>
        @endif
    @endforeach