    <section class="megamenu-section">
        <div class="container">
            <div class="megamenu-container">
                <nav class="navbar navbar-expand-lg megamenu-nav">
                      <!-- Toggle button -->
                      <button class="navbar-toggler px-0" type="button" data-mdb-toggle="collapse"
                        data-mdb-target="#navbarExampleOnHover" aria-controls="navbarExampleOnHover" aria-expanded="false"
                        aria-label="Toggle navigation">
                        <i class="fa-solid fa-bars"></i> 
                        <span>Show Content</span>
                      </button>
                  
                      <!-- Collapsible wrapper -->
                      <div class="collapse navbar-collapse megamenu-main-list" id="navbarExampleOnHover">
                        <!-- Left links -->
                        <ul class="navbar-nav me-auto ps-lg-0" style="padding-left: 0.15rem">
                          <!-- Navbar dropdown -->



                          @foreach($continents as $continent)
                          <?php
                                $countries = App\Models\Country::where('continent_id', $continent->id)->where('status', 1)->get();
                          ?>

                          @if(count($countries) > 0)
                          <li class="nav-item dropdown dropdown-hover position-static">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button"
                              data-mdb-toggle="dropdown" aria-expanded="false" style="text-transform: uppercase;">
                              {{ $continent->name }}
                            </a>



                            <!-- Dropdown menu -->
                            <div class="dropdown-menu w-100 mt-0" aria-labelledby="navbarDropdown" style="border-top-left-radius: 0; border-top-right-radius: 0;">
                  
                              <div class="container">
                                <div class="row my-4">

                                    @foreach($countries as $country)
                                      <div class="col-sm-6 col-md-4 col-lg-3 mb-3">
                                        <div class="asia-flag-container">
                                            <a href="{{ route('tour-packages', $country->slug) }}" target="_blank">
                                                <div class="d-flex asia-flag">
                                                    <div class="megamenu-flag">
                                                        <img src="{{asset($country->image)}}" alt="{{ $country->name }}">
                                                    </div>
                                                    <div>
                                                        <p>{{ $country->name }}</p>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                      </div>
                                    @endforeach
                                  
                        
                                  
                                </div>
                              </div>
                            </div>
                          </li>
                          @endif

                          @endforeach

                          <li class="nav-item dropdown dropdown-hover position-static">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown6" role="button"
                              data-mdb-toggle="dropdown" aria-expanded="false">
                            MULTI COUNTRY TOURS
                            </a>
                            <!-- Dropdown menu -->
                            <div class="dropdown-menu w-100 mt-0" aria-labelledby="navbarDropdown6" style="border-top-left-radius: 0; border-top-right-radius: 0;">
                                <div class="container">
                                    <div class="row my-4 g-4">


                                        @foreach($multi_country_tours as $tour_service)
                                        <?php
                                            $tour_countries = App\Models\TourServiceCountry::where('tour_service_id', $tour_service->id)->get();
                                        ?>

                                            @if(count($tour_countries) > 1)
                                            <div class="col-12 col-lg-6 mb-3">
                                                <div class="multitour-container">
                                                    <a href="{{ route('/tour', ['id' => $tour_service->id, 'slug' => $tour_service->slug]) }}" target="_blank">
                                                        <div class="d-flex multitour-single-content">
                                                            <div class="megamenu-multi-content">
                                                                <img src="{{asset($tour_service->meta_image)}}" alt="{{ $tour_service->title }}">
                                                            </div>
                                                            <div>
                                                                <p> {{ $tour_service->title }} </p>
                                                                <p>Starts from BDT. {{ $tour_service->price_start_per_person ?? 0 }} Per Person</p>
                                                                <div class="mb-2 mt-2">
                                                                    @foreach($tour_countries as $tour_country)

                                                                    <?php
                                                                        $colorCode = '#' . str_pad(dechex(random_int(0, 16777215)), 6, '0', STR_PAD_LEFT);
                                                                    ?>

                                                                        <span class="badge" style="background: {{ $colorCode }};">{{ $tour_country->country->name ?? '' }}</span>

                                                                    @endforeach
                                                                </div>
                                                                <div>
                                                                    <span class="badge bg-success">Tour</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                              </div>
                                            @endif
                                        @endforeach


                                    </div>
                                </div>
                            </div>
                          </li>
                        </ul>
                        <!-- Left links -->
                      </div>
                      <!-- Collapsible wrapper -->
                  </nav>
            </div>
        </div>
    </section>
