@extends('frontend.layouts.app')
@section('head')
<title> {{ $blog->title }} | {{ $site_info->name ?? '' }}</title>
<meta name="csrf-token" content="{{csrf_token()}}">
  <meta name="description" content="{{ $blog->meta_description ?? '' }}" />

  <meta property="type" content="Website" />

  <link rel="canonical" href="{{ route('blog', ['id' => $blog->id, 'slug' => $blog->slug]) }}" />

  <meta name="robots" content="index,allow" />

  <meta name="author" content="{{ $site_info->name ?? '' }}" />

  <meta name="publisher" content="{{ $site_info->name ?? '' }}" />

  <meta property="site_name" content="{{ $site_info->name ?? '' }}" />

  <meta property="og:url" content="{{ route('blog', ['id' => $blog->id, 'slug' => $blog->slug]) }}/" />

  <meta property="og:type" content="website" />

  <meta property="og:title" content=" {{ $blog->meta_title }}| {{ $site_info->name ?? '' }}" />

  <meta property="og:description" content="{{ $blog->meta_description ?? '' }}" />

  <meta property="og:keywords" content="{{ $blog->meta_keywords ?? '' }}" />

  <meta property="og:image" content="{{ asset($blog->image ?? '') }}" />

  <meta name="twitter:card" content="summary" />

  <meta name="twitter:site" content="@ {{ $site_info->name ?? '' }}" />

  <meta name="twitter:creator" content="@ {{ $site_info->name ?? '' }}" />

  <meta property="twitter:url" content="{{ route('blog', ['id' => $blog->id, 'slug' => $blog->slug]) }}/" />

  <meta property="twitter:title" content=" {{ $blog->meta_title }}| {{ $site_info->name ?? '' }}" />

  <meta property="twitter:description" content="{{ $blog->meta_description ?? '' }}" />

  <meta property="twitter:keywords" content="{{ $blog->meta_keywords ?? '' }}" />

  <meta property="twitter:image" content="{{ asset($blog->image ?? '') }}" />


@endsection
@section('content')

 <section class="about-page-banner-section" style="background-image: url({{ asset($blog->cover_image) }});">
    <div class="container">
        <div class="about-slug text-center">
            <h2 class="">{{ $blog->title }}</h2>
        </div>
    </div>
    <div class="about-page-banner-overlay"></div>
 </section>

 <section class="company-overview-container-section">
    <div class="container">
      <div class="row g-4">
        <div class="col-md-9">
            <div class="blog-list-container">
                <div class="row g-4">
                    <div class="col-12">
                        <div class="blog-cart">
                           <div class="row">
                            <div class="col-12">
                                <div class="blog-details-thumbnail text-center">
                                    <img src="{{ asset($blog->image) }}" alt="{{ $blog->title }}">
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="blog-sort-details">
                                    <h4><a href="#">{{ $blog->title }}</a></h4>
                                    <p class="post-author m-2"><span> <i class="fa-solid fa-user"></i> Admin</span> <span><i class="fa-solid fa-calendar-days"></i>  {{ Carbon\Carbon::parse($blog->created_at)->format('M-d-Y') }} </span></p>
                                    <div class="blog-like-btn-wrapper">
                                        <!-- <button class="btn bg-primary text-white shadow-none"><span><i class="fa-solid fa-thumbs-up"></i></span> Like <span>0</span></button> -->
                                        <!-- <button class="btn bg-primary text-white shadow-none">Share</button> -->

										<a class="btn bg-primary text-white shadow-none" href="https://api.whatsapp.com/send?text={{ route('blog', ['id' => $blog->id, 'slug' => $blog->slug]) }}" data-action="share/whatsapp/share" target="_blank" style="padding: 1px 15px;background: #00A884 !important;"> <span style="    font-size: 8px; font-weight: 700;">Whatsapp</span>  </a>


                                        <div class="fb-share-button" data-href="{{ route('blog', ['id' => $blog->id, 'slug' => $blog->slug]) }}" data-layout="button_count" data-size="small"><a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fdaily24newsbd.com%2Fpm-urges-parents-to-encourage-their-children-to-play-outside&amp;src=sdkpreparse" class="fb-xfbml-parse-ignore">Share</a></div>


                                    </div>
                                </div>
                                <div class="blog-full-details">


                                	{!! $blog->blog_description !!}



                                </div>

                                <!-- <div class="blog-user-comment-form">
                                    <form action="">
                                        <div class="row">
                                            <div class="col-md-4 mb-3">
                                                <div class="form-input">
                                                    <label for=""><strong>Your Name</strong></label>
                                                    <input type="text" class="shadow-none form-control" placeholder="Your Name">
                                                </div>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <div class="form-input">
                                                    <label for=""><strong>Your Mobile No</strong></label>
                                                    <input type="text" class="shadow-none form-control" placeholder="Your Mobile No">
                                                </div>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <div class="form-input">
                                                    <label for=""><strong>Your Email Address</strong></label>
                                                    <input type="email" class="shadow-none form-control" placeholder="Your Email Address">
                                                </div>
                                            </div>
                                            <div class="col-12 mb-3">
                                                <div class="form-input">
                                                    <label for=""><strong>Your Address</strong></label>
                                                    <input type="text" class="shadow-none form-control" placeholder="Your Address">
                                                </div>
                                            </div>
                                            <div class="col-12 mb-3">
                                                <div class="form-input">
                                                    <label for=""><strong>Your Comment</strong></label>
                                                    <textarea name="" id="" cols="30" rows="4" class="form-control shadow-none" placeholder="Entry Your Comment"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <button class="btn btn-primary text-uppercase">Submit Comment <i class="fa-solid fa-paper-plane"></i></button>
                                            </div>
                                        </div>
                                    </form>

                                </div> -->
                            </div>
                           </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="blog-category-list-wrapper blog-details-lists ps-md-5">
 
                <div class="our-tour-pakage mb-4">
                    <h4 class="text-uppercase">Recent Post</h4>



                    @foreach($recent_posts as $item)
                    <div class="row g-2">
                        <div class="col-3">
                            <div class="tour-pakage-img-blog-list">
                                <img src="{{ asset($item->image) }}" alt="{{ $item->title }}">
                            </div>
                        </div>
                        <div class="col-9">
                            <div class="tour-pakage-info-blog-page">
                                <a href="{{ route('blog', ['id' => $item->id, 'slug' => $item->slug]) }}">{{ $item->title }}</a>
                            </div>
                        </div>
                    </div>
             		@endforeach



                </div>


                <div class="our-services">
                    <h4 class="text-uppercase">Blog Cagegories</h4>
                    <ul>

                    	@foreach($categories as $item)
                        <li><a href="{{ route('category', ['id' => $item->id, 'slug' => $item->slug]) }}">{{ $item->name }}</a></li>
                        @endforeach

                    </ul>
                </div>


                @include('frontend.components.sidebar_tour_packages')


                @include('frontend.components.sidebar_umrah_packages')


                @include('frontend.components.sidebar_visa_packages')

            </div>
        </div>
      </div>
    </div>
 </section>


@endsection
