@extends('frontend.layouts.app')
@section('head')

<?php
    $host = url()->full();
?>


<title> {{ $category->name }} Blog | {{ $site_info->name ?? '' }}</title>
<meta name="csrf-token" content="{{csrf_token()}}">
  <meta name="description" content="{{ $site_info->meta_description ?? '' }}" />

  <meta property="type" content="Website" />

  <link rel="canonical" href="{{ $host }}" />

  <meta name="robots" content="index,allow" />

  <meta name="author" content="{{ $site_info->name ?? '' }}" />

  <meta name="publisher" content="{{ $site_info->name ?? '' }}" />

  <meta property="site_name" content=" {{ $category->name }} Blog | {{ $site_info->name ?? '' }}" />

  <meta property="og:url" content="{{ $host }}/" />

  <meta property="og:type" content="website" />

  <meta property="og:title" content=" {{ $category->name }} Blog | {{ $site_info->name ?? '' }}" />

  <meta property="og:description" content="{{ $site_info->meta_description ?? '' }}" />

  <meta property="og:keywords" content="{{ $site_info->meta_keywords ?? '' }}" />

  <meta property="og:image" content="{{ asset($site_info->meta_image ?? '') }}" />

  <meta name="twitter:card" content="summary" />

  <meta name="twitter:site" content="@ {{ $site_info->name ?? '' }}" />

  <meta name="twitter:creator" content="@ {{ $site_info->name ?? '' }}" />

  <meta property="twitter:url" content="{{ $host }}/" />

  <meta property="twitter:title" content=" {{ $category->name }} Blog | {{ $site_info->name ?? '' }}" />

  <meta property="twitter:description" content="{{ $site_info->meta_description ?? '' }}" />

  <meta property="twitter:keywords" content="{{ $site_info->meta_keywords ?? '' }}" />

  <meta property="twitter:image" content="{{ asset($site_info->meta_image ?? '') }}" />


@endsection
@section('content')


 <section class="about-page-banner-section">
    <div class="container">
        <div class="about-slug text-center">
            <h2 class=""> {{ $category->name }}</h2>
        </div>
    </div>
    <div class="about-page-banner-overlay"></div>
 </section>

 <section class="company-overview-container-section">
    <div class="container">
      <div class="row g-4">
        <div class="col-md-8">
            <div class="blog-list-container">
                <div class="d-flex justify-content-between all-blog-badge-title">
                    <div class="all-blog-badge">
                        <h3>All Blogs of  {{ $category->name }} category <button> {{ $blogs->count() }} </button></h3>
                    </div>
                    <div></div>
                </div>
                <div class="row g-4">


                	@foreach($blogs as $item)
                    <div class="col-12">
                        <div class="blog-cart">
                           <div class="row">
                            <div class="col-md-3">
                                <div class="blog-thumbnail text-center">
                                    <img src="{{ asset($item->image) }}" alt="{{ $item->title }}">
                                </div>
                            </div>
                            <div class="col-md-9">
                                <div class="blog-sort-details">
                                    <h4><a href="{{ route('blog', ['id' => $item->id, 'slug' => $item->slug]) }}"> {{ $item->title }} </a></h4>
                                    <p class="post-author m-2"><span> <i class="fa-solid fa-user"></i> Admin</span> <span><i class="fa-solid fa-calendar-days"></i>  {{ Carbon\Carbon::parse($item->created_at)->format('M-d-Y') }} </span></p>
                                    <div class="blog-like-btn-wrapper">

                                        <!-- <button class="btn bg-primary text-white shadow-none"><span><i class="fa-solid fa-thumbs-up"></i></span> Like <span>0</span></button> -->

                                        <!-- <button class="btn bg-primary text-white shadow-none">Share</button> -->


										<a class="btn bg-primary text-white shadow-none" href="https://api.whatsapp.com/send?text={{ route('blog', ['id' => $item->id, 'slug' => $item->slug]) }}" data-action="share/whatsapp/share" target="_blank" style="padding: 1px 15px;background: #00A884 !important;"> <span style="    font-size: 8px; font-weight: 700;">Whatsapp</span>  </a>


                                        <div class="fb-share-button" data-href="{{ route('blog', ['id' => $item->id, 'slug' => $item->slug]) }}" data-layout="button_count" data-size="small"><a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fdaily24newsbd.com%2Fpm-urges-parents-to-encourage-their-children-to-play-outside&amp;src=sdkpreparse" class="fb-xfbml-parse-ignore">Share</a></div>


                                    </div>
                                    <div>
                                        <p> {!! $item->meta_description !!}</p>
                                    </div>
                                    <div class="single-blog-read-more-btn">
                                        <a href="{{ route('blog', ['id' => $item->id, 'slug' => $item->slug]) }}" class="text-uppercase">read more <i class="fa-solid fa-arrow-right"></i></a>
                                    </div>

                                </div>
                            </div>
                           </div>
                        </div>
                    </div>
                    @endforeach

                    {{ $blogs->links() }}



                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="blog-category-list-wrapper ps-md-5">
                <div class="our-services">
                    <h4 class="text-uppercase">Blog Cagegories</h4>
                    <ul>

                    	@foreach($categories as $item)
                        <li><a href="{{ route('category', ['id' => $item->id, 'slug' => $item->slug]) }}">{{ $item->name }}</a></li>
                        @endforeach

                    </ul>
                </div>
                
                @include('frontend.components.sidebar_tour_packages')


                @include('frontend.components.sidebar_umrah_packages')


                @include('frontend.components.sidebar_visa_packages')


            </div>
        </div>
      </div>
    </div>
 </section>


@endsection
