@extends('frontend.layouts.app')
@section('head')
<title> {{ $tour_package->title }} | {{ $site_info->name ?? '' }}</title>
<meta name="csrf-token" content="{{csrf_token()}}">
  <meta name="description" content="{{ $site_info->meta_description ?? '' }}" />

  <meta property="type" content="Website" />

  <link rel="canonical" href="{{ route('/tour', ['id' => $tour_package->id, 'slug' => $tour_package->slug]) }}" />

  <meta name="robots" content="index,allow" />

  <meta name="author" content="{{ $site_info->name ?? '' }}" />

  <meta name="publisher" content="{{ $site_info->name ?? '' }}" />

  <meta property="site_name" content=" {!! $tour_package->meta_title ?? $tour_package->title !!} | {{ $site_info->name ?? '' }}" />

  <meta property="og:url" content="{{ route('/tour', ['id' => $tour_package->id, 'slug' => $tour_package->slug]) }}/" />

  <meta property="og:type" content="website" />

  <meta property="og:title" content=" {!! $tour_package->meta_title ?? $tour_package->title !!} | {{ $site_info->name ?? '' }}" />

  <meta property="og:description" content="{{ $tour_package->meta_description ?? '' }}" />

  <meta property="og:keywords" content="{{ $tour_package->meta_keywords ?? '' }}" />

  <meta property="og:image" content="{{ asset($tour_package->meta_image ?? '') }}" />

  <meta name="twitter:card" content="summary" />

  <meta name="twitter:site" content="@ {{ $site_info->name ?? '' }}" />

  <meta name="twitter:creator" content="@ {{ $site_info->name ?? '' }}" />

  <meta property="twitter:url" content="{{ route('/tour', ['id' => $tour_package->id, 'slug' => $tour_package->slug]) }}/" />

  <meta property="twitter:title" content=" {!! $tour_package->meta_title ?? $tour_package->title !!} | {{ $site_info->name ?? '' }}" />

  <meta property="twitter:description" content="{{ $tour_package->meta_description ?? '' }}" />

  <meta property="twitter:keywords" content="{{ $tour_package->meta_keywords ?? '' }}" />

  <meta property="twitter:image" content="{{ asset($tour_package->meta_image ?? '') }}" />


@endsection
@section('content')



 <section class="umrapackage-banner-section" style="background-image: url({{ asset($tour_package->meta_image)  }});">
  <div class="container">
      <div class="about-slug text-center">
          <h2 class=""> {{ $tour_package->title }} </h2>
      </div>
  </div>
  <div class="umra-page-banner-overlay"></div>
</section>

 <section class="company-overview-container-section">
    <div class="container">
      <div class="row g-4">
        <div class="col-md-8">
            <div class="umrah-package-details-container">
                <div class="umrah-package-details-slider-one-image">

                	@foreach($tour_package_images as $item)
                    <div class="single-one-image">
                        <img src="{{asset($item->image)}}" alt="">
                    </div>
                    @endforeach

                </div>
               <div class="umrah-package-details-slider-bottom">
                <div class="umrah-package-details-slider-many-image">

                	@foreach($tour_package_images as $item)
                    <div class="single-many-image">
                        <img src="{{asset($item->image)}}" alt="">
                    </div>
                    @endforeach

                </div>

                <div class="umra-package-slider-btn d-flex justify-content-between w-100">
                    <span class="arrow-prev"><i class="fa-solid fa-circle-chevron-left"></i></span>
                    <span class="arrow-next"><i class="fa-solid fa-circle-chevron-right"></i></span>
                </div>
               </div>
            </div>

            <!-----END:: SLIDER -------->
            <!-----START:: UMRAH ACCORDION-------->

            <section class="umrah-package-details-accordion-section">
                    <div class="accordion" id="accordionExample">


                    	@if($tour_package->tour_details)
                        <div class="accordion-item ">
                          <h2 class="accordion-header" id="detailHeadLine">
                            <button class="accordion-button shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOneDetail" aria-expanded="true" aria-controls="collapseOneDetail">
                              DETAILS
                            </button>
                          </h2>
                          <div id="collapseOneDetail" class="accordion-collapse collapse show" aria-labelledby="detailHeadLine" data-bs-parent="#accordionExample">
                            <div class="accordion-body details-body">


                            	{!! $tour_package->tour_details !!}


                            </div>
                          </div>
                        </div>
                        @endif


                    	@if($tour_package->tour_other_information)
                        <div class="accordion-item ">
                          <h2 class="accordion-header" id="OtherInformationHeadLine">
                            <button class="accordion-button shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOneOtherInformation" aria-expanded="false" aria-controls="collapseOneOtherInformation">
                              OTHER INFORMATION
                            </button>
                          </h2>
                          <div id="collapseOneOtherInformation" class="accordion-collapse collapse" aria-labelledby="OtherInformationHeadLine" data-bs-parent="#accordionExample">
                            <div class="accordion-body details-body">


                            	{!! $tour_package->tour_other_information !!}


                            </div>
                          </div>
                        </div>
                        @endif


                        @if($tour_package->tour_itinerary)
                        <div class="accordion-item">
                          <h2 class="accordion-header" id="headingTwoItInter">
                            <button class="accordion-button collapsed shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwoItInter" aria-expanded="false" aria-controls="collapseTwoItInter">
                              ITINERARY
                            </button>
                          </h2>
                          <div id="collapseTwoItInter" class="accordion-collapse collapse" aria-labelledby="headingTwoItInter" data-bs-parent="#accordionExample">
                            <div class="accordion-body itinerary-body">

                            	{!! $tour_package->tour_itinerary !!}

                            </div>
                          </div>
                        </div>
                        @endif



                        @if($tour_package->tour_remark)
                        <div class="accordion-item">
                          <h2 class="accordion-header" id="headingTwoRemark">
                            <button class="accordion-button collapsed shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwoRemark" aria-expanded="false" aria-controls="collapseTwoRemark">
                              REMARKS
                            </button>
                          </h2>
                          <div id="collapseTwoRemark" class="accordion-collapse collapse" aria-labelledby="headingTwoRemark" data-bs-parent="#accordionExample">
                            <div class="accordion-body itinerary-body">

                            	{!! $tour_package->tour_remark !!}

                            </div>
                          </div>
                        </div>
                        @endif
                        


                        
                        <div class="accordion-item">
                          <h2 class="accordion-header" id="headingFourFAQ">
                            <button class="accordion-button collapsed shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFourFAQ" aria-expanded="false" aria-controls="collapseFourFAQ">
                              Faq
                            </button>
                          </h2>
                          <div id="collapseFourFAQ" class="accordion-collapse collapse" aria-labelledby="headingFourFAQ" data-bs-parent="#accordionExample">
                            <div class="accordion-body faq-body">

                            	@if($tour_package->tour_faq)
                                	{!! $tour_package->tour_faq !!}
                                @endif

                                <div class="faq-contact-form">
                                  <h4>Do you have any questions? Fill up this form.</h4>

                                    @if ($errors->any())
                                        <div class="alert alert-danger">
                                            <ul>
                                                @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif
 
                                  
                                  <form action="{{ route('submit_question_faq') }}" method="post">
                                    @csrf
                                    <div class="single-form mb-3">
                                      <input type="hidden" name="type" value="Tour">
                                      <input type="text" name="full_name" class="form-control" placeholder="Enter Your Name" required>
                                    </div>
                                    <div class="single-form mb-3">
                                      <input type="text" name="phone_number" class="form-control" placeholder="Enter Your Mobile Number" required>
                                    </div>
                                    <div class="single-form mb-3">
                                      <input type="text" name="email_address" class="form-control" placeholder="Enter Your Email Address" required>
                                    </div>
                                    <div class="single-form mb-3">
                                      <textarea name="question" id="" class="form-control" cols="30" rows="3" placeholder="Enter Your Questions?" required></textarea>
                                    </div>
                                    <div class="single-form mb-3">
                                      <button type="submit" class="btn btn-success w-50 fw-bold"> Sumbit <i class="fa-solid fa-paper-plane"></i></button>
                                    </div>
                                   
                                  </form>
                                </div>

                            </div>
                          </div>
                        </div>
                        

                        <div class="accordion-item ">
                          <h2 class="accordion-header" id="ContactHeadLine">
                            <button class="accordion-button shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOneContact" aria-expanded="false" aria-controls="collapseOneContact">
                              CONTACT
                            </button>
                          </h2>
                          <div id="collapseOneContact" class="accordion-collapse collapse" aria-labelledby="ContactHeadLine" data-bs-parent="#accordionExample">
                            <div class="accordion-body details-body">


                                <div class="footer-contact-us">
                          
                                    <ul class="p-0">
                                        <li class="d-flex">
                                            <span class="pe-2" style="color: black;"><i class="fa-solid fa-location-dot"></i></span>
                                            <a href="#" style="color: black;">{{ $site_info->address ?? '#' }}</a>
                                        </li>
                                        
                                        <li class="d-flex">
                                            <span class="pe-2" style="color: black;"><i class="fa-solid fa-phone"></i></span>
                                            <div>
                                                <a href="#" style="color: black;">{{ $site_info->phone_number }}</a>
                                            </div>
                                        </li>
                                        <li class="d-flex">
                                            <span class="pe-2" style="color: black;"><i class="fa-solid fa-envelope"></i></span>
                                          <div>

                                            <?php
                                                $emails = explode(", ", $site_info->email);
                                                $totalEmails = count($emails);
                                                $i = 1;

                                            ?>

                                            @foreach($emails as $item)

                                            <a href="#" class="" style="color: black;">{{ $item }}  @if($i != $totalEmails)  {{ ',' }} @endif </a>

                                                @php $i++; @endphp
                                            @endforeach

                                          </div>
                                        </li>
                                        <li class="d-flex">
                                            <span class="pe-2" style="color: black;"><i class="fa-solid fa-location-arrow"></i></span>
                                            <a href="{{ $site_info->google_map_address ?? '#' }}" target="_blank" style="color: blue;">GET DIRECTION ON GOOGLE MAP</a>
                                        </li>
                                    </ul>
                                </div>


                            </div>
                          </div>
                        </div>



                      </div>
             </section>

        </div>
        <div class="col-md-4">
            <div class="blog-category-list-wrapper blog-details-lists ps-lg-3">
                <div class="package-details-sort-display">
                  <h6> {{ $tour_package->title }} </h6>
                  <div class="p-3">
                   <p class="">Starts from BDT. {{ $tour_package->price_start_per_person }} /Per Person</p>
                   <p>Valid Till: {{ Carbon\Carbon::parse($tour_package->expire_date)->format('d M Y') }}</p>

                   	@if(count($tour_countries) > 0)
                    <div class="umrah-cart-badge">

                    	@foreach($tour_countries as $tour_country)
                       		<span class="badge" style="background-color: red !important;">{{ $tour_country->country->name ?? '' }}</span>
                		@endforeach

                    </div>
                    @endif

                   <div class="umrah-cart-badge" style="margin-top: 0;"><span class="badge">Tour</span>
                    </div>
                  </div>
                </div>

                
                @include('frontend.components.sidebar_contact_us')

                @include('frontend.components.sidebar_you_may_also_like')


                @include('frontend.components.sidebar_umrah_packages')


                @include('frontend.components.sidebar_visa_packages')

            </div>
        </div>


        @if($tour_package->best_tour_service_for)
        <div class="col-md-12">
        	<div style="background: white;border: 1px solid #e9e9e9;padding: 11px;">
        		{!! $tour_package->best_tour_service_for !!}
        	</div>
        </div>
        @endif

      </div>
    </div>
 </section>



@endsection
