<?php

use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\CountryController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\FAQController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\ProgramCategoryController;
use App\Http\Controllers\Admin\ProgramController;
use App\Http\Controllers\Admin\BannerController;
use App\Http\Controllers\Admin\OtherServiceController;
use App\Http\Controllers\Admin\FeedbackController;
use App\Http\Controllers\Admin\WebsiteInformationController;
use App\Http\Controllers\Admin\ContactMessageController;
use App\Http\Controllers\Admin\AboutusController;
use App\Http\Controllers\Admin\BlogController;
use App\Http\Controllers\Admin\PageCategoryController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\ContinentController;
use App\Http\Controllers\Admin\VisaServiceController;
use App\Http\Controllers\Admin\TourServiceController;
use App\Http\Controllers\Admin\UmrahServiceController;
use App\Http\Controllers\Admin\PageDescriptionController;
use App\Http\Controllers\Admin\GuestQuestionController;
use App\Http\Controllers\Admin\HomePageSettingController;
use App\Http\Controllers\Admin\GuestRequestController;
use App\Http\Controllers\Admin\SubscriptionController;


use App\Http\Controllers\HomeController;
use App\Http\Controllers\AuthenticationController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\StudentExamController;
use App\Http\Controllers\AjaxController;


use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/', [HomeController::class, 'welcome'])->name('/');
Route::get('about-us', [HomeController::class, 'about_us'])->name('about-us');
Route::get('messege-from-ceo', [HomeController::class, 'messege_from_ceo'])->name('messege-from-ceo');
Route::get('contactus', [HomeController::class, 'contact'])->name('contactus');
Route::post('subscription', [HomeController::class, 'subscription'])->name('subscription');


Route::get('blogs', [HomeController::class, 'blogs'])->name('blogs');
Route::get('blog/{id}/{slug}', [HomeController::class, 'blog_details'])->name('blog');
Route::get('category/{id}/{slug}', [HomeController::class, 'category_wise_blogs'])->name('category');



Route::get('umrah-packages-from-bangladesh', [HomeController::class, 'umrah_packages_from_bangladesh'])->name('umrah-packages-from-bangladesh');
Route::get('umrah/{id}/{slug}', [HomeController::class, 'umrah_package_details'])->name('/umrah');




Route::get('holiday-packages-from-bangladesh', [HomeController::class, 'holiday_packages_from_bangladesh'])->name('holiday-packages-from-bangladesh');
Route::get('tour-packages/{slug}', [HomeController::class, 'tour_packages'])->name('tour-packages');
Route::get('tour/{id}/{slug}', [HomeController::class, 'tour_package_details'])->name('/tour');





Route::get('visa-processing-agent-bangladesh', [HomeController::class, 'visa_processing_agent_bangladesh'])->name('visa-processing-agent-bangladesh');
Route::get('visa/{slug}', [HomeController::class, 'visa'])->name('/visa');



Route::get('page/{slug}', [HomeController::class, 'page'])->name('page');



Route::get('request', [HomeController::class, 'request'])->name('request');



Route::get('contact', [HomeController::class, 'contact'])->name('contact');
Route::post('submit_message', [HomeController::class, 'submit_message'])->name('submit_message');
Route::post('submit_question_faq', [HomeController::class, 'submit_question_faq'])->name('submit_question_faq');
Route::post('send_tour_request', [HomeController::class, 'send_tour_request'])->name('send_tour_request');
Route::post('send_visa_request', [HomeController::class, 'send_visa_request'])->name('send_visa_request');


//Ajax
Route::post('get_banner', [HomeController::class, 'get_banner'])->name('get_banner');
Route::post('get_umrah_packages', [AjaxController::class, 'get_umrah_packages'])->name('get_umrah_packages');
Route::post('get_tour_packages', [AjaxController::class, 'get_tour_packages'])->name('get_tour_packages');
Route::post('get_visa_packages', [AjaxController::class, 'get_visa_packages'])->name('get_visa_packages');
Route::post('get_country_wsie_tour_packages', [AjaxController::class, 'get_country_wsie_tour_packages'])->name('get_country_wsie_tour_packages');
Route::post('get_country', [AjaxController::class, 'get_country'])->name('get_country');
Route::post('get_blogs', [AjaxController::class, 'get_blogs'])->name('get_blogs');




Route::prefix('admin')->group(function (){

    Route::get('/login', [AdminController::class, 'login']);
    Route::get('/dashboard', [AdminController::class, 'home'])->name('admin-dashboard');
    Route::post('/login', [AdminController::class, 'admin_login'])->name('admin-login');
    Route::get('/logout', [AdminController::class, 'admin_logout'])->name('admin-logout');
    Route::get('/forget-password', 'AdminController@forget_password')->name('forget-password');


    Route::group(['middleware' => ['AdminUserMiddleWare']], function () {
        Route::get('/dashboard', [AdminController::class, 'home'])->name('admin-dashboard');
        Route::get('/profile', [AdminController::class, 'profile'])->name('profile');
        Route::post('/profile', [AdminController::class, 'save_profile'])->name('save-profile');
        Route::get('/change-password', [AdminController::class, 'change_password'])->name('change-password');
        Route::post('/save-password', [AdminController::class, 'save_password'])->name('save-password');


        Route::get('/lock-screen', [AdminController::class, 'lock_screen'])->name('admin.lock-screen');


        //website setting
        Route::get('/site-setting', [SettingController::class, 'setting'])->name('site-setting');
        Route::post('/save-logo', [SettingController::class, 'save_logo'])->name('save-logo');
        Route::post('/save-favicon', [SettingController::class, 'save_favicon'])->name('save-favicon');
        Route::post('/save-site-info', [SettingController::class, 'save_site_info'])->name('save-site-info');

        Route::post('/ck-upload', [SettingController::class,'ck_upload'])->name('ckeditor.upload');



        //program_category
        Route::resource('program_category', ProgramCategoryController::class);



        //program
        Route::resource('program', ProgramController::class);

        //banner
        Route::resource('banner', BannerController::class);


        //other_service
        Route::resource('other_service', OtherServiceController::class);


        //feedback
        Route::resource('feedback', FeedbackController::class);


        //website_information
        Route::resource('website_information', WebsiteInformationController::class);



        //faq
        Route::resource('faq', FAQController::class);

        //category
        Route::resource('category', CategoryController::class);

        //blog
        Route::resource('blog', BlogController::class);


        //aboutus
        Route::resource('aboutus', AboutusController::class);

        //page_category
        Route::resource('page_category', PageCategoryController::class);

        //page
        Route::resource('page', PageController::class);

        //page_description
        Route::resource('page_description', PageDescriptionController::class);

        //continent
        Route::resource('continent', ContinentController::class);

        //country
        Route::resource('country', CountryController::class);

        //guest_question
        Route::resource('guest_question', GuestQuestionController::class);

        //guest_request
        Route::resource('guest_request', GuestRequestController::class);

        //home_page_setting
        Route::resource('home_page_setting', HomePageSettingController::class);

        //subscription
        Route::resource('subscription', SubscriptionController::class);
        
        //visa_service
        Route::resource('visa_service', VisaServiceController::class);
        Route::get('/delete_visa_service_image/{id}', [VisaServiceController::class, 'delete_visa_service_image'])->name('delete_visa_service_image');

    
        //tour_service
        Route::resource('tour_service', TourServiceController::class);
        Route::get('/delete_tour_service_image/{id}', [TourServiceController::class, 'delete_tour_service_image'])->name('delete_tour_service_image');

    
        //umrah_service
        Route::resource('umrah_service', UmrahServiceController::class);
        Route::get('/delete_umrah_service_image/{id}', [UmrahServiceController::class, 'delete_umrah_service_image'])->name('delete_umrah_service_image');

  
        //order
        Route::resource('order', OrderController::class);
        Route::get('/pending-order', [OrderController::class, 'pending_order'])->name('pending-order');
        Route::get('/rejected-order', [OrderController::class, 'rejected_order'])->name('rejected-order');
        Route::get('/confirmed-order', [OrderController::class, 'confirmed_order'])->name('confirmed-order');
        Route::get('/in-transit-order', [OrderController::class, 'in_transit_order'])->name('in-transit-order');
        Route::get('/delivered-order', [OrderController::class, 'delivered_order'])->name('delivered-order');
        Route::get('/canceled-order', [OrderController::class, 'canceled_order'])->name('canceled-order');


        Route::post('/edit_order_model', [OrderController::class, 'edit_order_model'])->name('admin.edit_order_model');
        Route::post('/delete_model', [OrderController::class, 'delete_model'])->name('admin.delete_model');



        //contact_messages
        Route::get('/completed_contact_messages', [ContactMessageController::class, 'completed_contact_messages'])->name('completed_contact_messages');
        Route::get('/pending_contact_messages', [ContactMessageController::class, 'pending_contact_messages'])->name('pending_contact_messages');
        Route::get('/edit_contact_messages/{id}', [ContactMessageController::class, 'edit_contact_messages'])->name('edit_contact_messages');
        Route::post('/update_contact_messages/{id}', [ContactMessageController::class, 'update_contact_messages'])->name('update_contact_messages');
        Route::get('/delete_contact_messages/{id}', [ContactMessageController::class, 'delete_contact_messages'])->name('delete_contact_messages');






    });
});