
<?php $__env->startSection('head'); ?>

<?php
    $host = url()->full();
?>

<title><?php echo e($site_info->meta_title ?? ''); ?></title>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <meta name="description" content="<?php echo e($site_info->meta_description ?? ''); ?>" />

  <meta property="type" content="Website" />

  <link rel="canonical" href="<?php echo e($host); ?>" />

  <meta name="robots" content="index,allow" />

  <meta name="author" content="<?php echo e($site_info->name ?? ''); ?>" />

  <meta name="publisher" content="<?php echo e($site_info->name ?? ''); ?>" />

  <meta property="site_name" content="<?php echo e($site_info->meta_title ?? ''); ?>" />

  <meta property="og:url" content="<?php echo e($host); ?>/" />

  <meta property="og:type" content="website" />

  <meta property="og:title" content="<?php echo e($site_info->meta_title ?? ''); ?>" />

  <meta property="og:description" content="<?php echo e($site_info->meta_description ?? ''); ?>" />

  <meta property="og:keywords" content="<?php echo e($site_info->meta_keywords ?? ''); ?>" />

  <meta property="og:image" content="<?php echo e(asset($site_info->meta_image ?? '')); ?>" />

  <meta name="twitter:card" content="summary" />

  <meta name="twitter:site" content="@ <?php echo e($site_info->name ?? ''); ?>" />

  <meta name="twitter:creator" content="@ <?php echo e($site_info->name ?? ''); ?>" />

  <meta property="twitter:url" content="<?php echo e($host); ?>/" />

  <meta property="twitter:title" content="<?php echo e($site_info->meta_title ?? ''); ?>" />

  <meta property="twitter:description" content="<?php echo e($site_info->meta_description ?? ''); ?>" />

  <meta property="twitter:keywords" content="<?php echo e($site_info->meta_keywords ?? ''); ?>" />

  <meta property="twitter:image" content="<?php echo e(asset($site_info->meta_image ?? '')); ?>" />



    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "LocalBusiness",
            "name": "<?php echo e($site_info->name ?? ''); ?>",
            "url": "<?php echo e($host); ?>/",
            "logo": "<?php echo e(asset($site_info->logo_light ?? '')); ?>",
            "alternateName": "<?php echo e($site_info->meta_title ?? ''); ?>",
            "sameAs": [
                "<?php echo e($site_info->facebook ?? ''); ?>",
                "<?php echo e($site_info->linkedin ?? ''); ?>",
                "<?php echo e($site_info->instagram ?? ''); ?>"
            ],
            "contactPoint": [
                {
                "@type": "ContactPoint",
                "telephone": "<?php echo e($site_info->phone_number ?? ''); ?>",
                "contactType": "Technical Support",
                "email": "<?php echo e($site_info->email ?? ''); ?>",
                "areaServed": "BD",
                "availableLanguage": "en"
                },
                {
                "@type": "ContactPoint",
                "telephone": "<?php echo e($site_info->phone_number ?? ''); ?>",
                "contactType": "Sales Support",
                "email": "<?php echo e($site_info->email ?? ''); ?>",
                "areaServed": "BD",
                "availableLanguage": "en"
                },
                {
                "@type": "ContactPoint",
                "telephone": "<?php echo e($site_info->phone_number ?? ''); ?>",
                "contactType": "Warranty Support",
                "email": "<?php echo e($site_info->email ?? ''); ?>",
                "areaServed": "BD",
                "availableLanguage": "en"
                }
            ]
        }
    </script> 


<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div id="ajaxBanner">
  
</div>

<!-- <?php echo $__env->make('frontend.components.slider', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> -->


  <section class="about-home-page-section">
    <div class="container">
        <div class="row g-4">
            <div class="col-md-7">
                <div class="about-home-content">
                  <div class="mb-4">
                    <h2 class="text-uppercase mb-0">
                        About <span><?php echo e($site_info->name ?? ''); ?> </span>
                    </h2>
                    <h2 class="text-uppercase mb-0">
                     travel agency
                    </h2>
                  </div>

                    <?php echo $home_page_setting->home_page_about_section; ?>



                </div>
            </div>
          <div class="col-md-5">
                <div class="about-home-agency-video">

                    <iframe width="100%" height="315" src="https://www.youtube.com/embed/<?php echo e($home_page_setting->home_page_video_code_one); ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
                  
                    <iframe width="100%" height="315" src="https://www.youtube.com/embed/<?php echo e($home_page_setting->home_page_video_code_two); ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>

                </div>
            </div>
        </div>
    </div>
  </section>


  <?php if($home_page_setting->home_page_mission_and_vision_section ): ?>
  <section class="mission-vission-section">
    <div class="container">
        <div class="mission-vision-title mb-4">
            <h3>Mission & Vision</h3>
        </div>
        <div class="vission-mision-content">

            <?php echo $home_page_setting->home_page_mission_and_vision_section; ?>


        </div>
    </div>
  </section>
  <?php endif; ?>


  <?php if($home_page_setting->home_page_umrah_section ): ?>
  <section class="umra-pakage-section umra-package-section-home" style="background-image: url(<?php echo e(asset($home_page_setting->home_page_umrah_section_bg_image)); ?>);">
    <div class="container">
        <h3>Umrah Packages From Bangladesh</h3>
       <?php echo $home_page_setting->home_page_umrah_section; ?>

      </div>
    </div>
    <div class="umra-overlay">

    </div>
  </section>
  <?php endif; ?>



  <?php if($home_page_setting->home_page_tour_section ): ?>
  <section class="holiday-pakage-section">
    <div class="container">
        <h3>Cheap International Holiday Packages From Bangladesh</h3>


        <?php echo $home_page_setting->home_page_tour_section; ?>


       <h5>Check out the Latest Cost Effective Tour Packages for you to enjoy!</h5>
      <div class="text-center umra-pakage-button">
        <a href="<?php echo e(route('holiday-packages-from-bangladesh')); ?>">View All</a>
      </div>
    </div>
    <div class="umra-overlay">

    </div>
  </section>
  <?php endif; ?>


  <?php if($home_page_setting->home_page_visa_section ): ?>
  <section class="visa-pakage-section umra-package-section-home" style="background-image: url(<?php echo e(asset($home_page_setting->home_page_visa_section_bg_image)); ?>);">
    <div class="container">
        <h3>Visa Processing Services</h3>

        <?php echo $home_page_setting->home_page_visa_section; ?>


       <h5>Click here to apply for a Visa of a country of your choice!</h5>
      <div class="text-center umra-pakage-button">
        <a href="<?php echo e(route('visa-processing-agent-bangladesh')); ?>">View All</a>
      </div>
    </div>
    <div class="visa-overlay">

    </div>
  </section>
  <?php endif; ?>


  <?php if($home_page_setting->home_page_choose_us_des_one_section ): ?>
  <section class="home-page-why-choise-us-section">
    <div class="container">
        <div class="row">
            <div class="col-md-3">
                <div class="why-chose-us-img">
                    <img src="<?php echo e(asset($home_page_setting->home_page_why_choose_section_bg_image)); ?>" alt="">
                </div>
            </div>
            <div class="col-md-9">
                <div class="why-chose-us-content">
                    <h2><span>Why</span> Chose Us</h2>
                    <?php echo $home_page_setting->home_page_choose_us_des_one_section; ?>

                </div>
            </div>
        </div>
    </div>
    <div class="container">
       <div class="other-contant">
        <?php echo $home_page_setting->home_page_choose_us_des_two_section; ?>

    </div>

    </div>
  </section>
  <?php endif; ?>

   <section class="news-letter-section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-10 col-lg-6">
                <div class="news-letter-container text-center">
                    <h2>SUBSCRIBE OUR NEWSLETTER</h2>
                    <h4>SUBSCIBE TO RECEIVE OUR INTERESTING UPDATES</h4>
                    <form action="<?php echo e(route('subscription')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="single-form">
                            <input type="email" name="email" class="form-control" placeholder="Entry your email address">
                            <div class="single-form-icon">
                                <i class="fa-solid fa-envelope"></i>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="news-letter-overlay">
    </div>
  </section>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\office\obokash_tour\resources\views/welcome.blade.php ENDPATH**/ ?>