
<?php $__env->startSection('head'); ?>

	<title> Contact - <?php echo e($site_info->name ?? ''); ?></title>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


<section class="contact-us-section">
    <div class="container">
        <div class="row g-5">
            <div class="col-md-6">
                <div class="contact-form-body">
                    <h2 class="text-center pb-3">আমাদের সাথে যোগাযোগ করুন !</h2>

                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    
                    <form action="<?php echo e(route('submit_message')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label for="">আপনার নাম <sup class="text-danger">*</sup></label>
                            <input type="text" name="full_name" class="form-control shadow-none" placeholder="আপনার নাম লিখুন" required>
                        </div>                        
                        <div class="mb-3">
                            <label for="">আপনার মোবাইল নম্বর <sup class="text-danger">*</sup></label>
                            <input type="number" name="phone_number" class="form-control shadow-none"  placeholder="আপনার মোবাইল নম্বর দিন" required>
                        </div>                        
                        <div class="mb-3">
                            <label for="">আপনার ম্যাসেজ লিখুন <sup class="text-danger">*</sup></label>
                            <textarea name="message" id="" cols="30" rows="3" class="form-control" placeholder="আপনার ম্যাসেজ লিখুন"></textarea>
                        </div>                        
                        <div>
                            <button type="submit">সাবমিট করুন <i class="fa-solid fa-paper-plane"></i></button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-md-6">
                <div class="contact-us-help-img">
                    <img src="<?php echo e(asset('public/frontend/')); ?>/images/grievances-image.png" alt="">
                </div>
            </div>
        </div><!-- end row -->
    </div><!-- end container -->
</section>

<div class="section-contact-map">
    <div class="container">
        <div class="row g-5">
            <div class="col-md-6">
                <div class="contact-form-body">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d21262.17690956187!2d90.40015408864411!3d23.759653668379276!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3755b8a1221c6a79%3A0xe2a307a9fc9b3a48!2sConcord%20Center%20Point%2C%20Kazi%20Nazrul%20Islam%20Ave%2C%20Dhaka%201215!5e0!3m2!1sen!2sbd!4v1679466681335!5m2!1sen!2sbd" width="100%" height="300" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>
            </div>
            <div class="col-md-6">
                <div class="contact-form-body quick-contact" >
                    <h2 class="pb-3 text-center border-bottom">আমাদের সাথে যোগাযোগ করার ঠিকানা</h2>
                    <div class="d-flex contact-us-info">
                        <span><i class="fa-solid fa-phone"></i></span>
                        <p> <?php echo e($site_info->phone_number ?? ''); ?> </p>
                    </div>   
                    <div class="d-flex contact-us-info">
                        <span><i class="fa-solid fa-envelope"></i></span>
                        <p> <?php echo e($site_info->email ?? ''); ?>  </p>
                    </div>                    
                    <div class="d-flex contact-us-info">
                        <span><i class="fa-brands fa-facebook"></i></span>
                        <p>  <?php echo e($site_info->facebook ?? ''); ?>  </p>
                    </div>                    
                    <div class="d-flex contact-us-info">
                        <span><i class="fa-solid fa-location-dot"></i></span>
                        <p> <?php echo e($site_info->address ?? ''); ?> </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\office\gravity_new\resources\views/frontend/pages/contact.blade.php ENDPATH**/ ?>