
<?php $__env->startSection('head'); ?>
<title> Contact us | <?php echo e($site_info->name ?? ''); ?></title>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <meta name="description" content="<?php echo e($blog->meta_description ?? ''); ?>" />

  <meta property="type" content="Website" />

  <link rel="canonical" href="<?php echo e($host); ?>" />

  <meta name="robots" content="index,allow" />

  <meta name="author" content="<?php echo e($site_info->name ?? ''); ?>" />

  <meta name="publisher" content="<?php echo e($site_info->name ?? ''); ?>" />

  <meta property="site_name" content=" Contact us| <?php echo e($site_info->name ?? ''); ?>" />

  <meta property="og:url" content="<?php echo e($host); ?>/" />

  <meta property="og:type" content="website" />

  <meta property="og:title" content=" Contact us| <?php echo e($site_info->name ?? ''); ?>" />

  <meta property="og:description" content="<?php echo e($blog->meta_description ?? ''); ?>" />

  <meta property="og:keywords" content="<?php echo e($blog->meta_keywords ?? ''); ?>" />

  <meta property="og:image" content="<?php echo e(asset($blog->image ?? '')); ?>" />

  <meta name="twitter:card" content="summary" /><meta name="twitter:site" content="{{ $site_info->name ?? '' }}" />

  <meta name="twitter:creator" content="@ <?php echo e($site_info->name ?? ''); ?>" />

  <meta property="twitter:url" content="<?php echo e($host); ?>/" />

  <meta property="twitter:title" content=" Contact us| <?php echo e($site_info->name ?? ''); ?>" />

  <meta property="twitter:description" content="<?php echo e($blog->meta_description ?? ''); ?>" />

  <meta property="twitter:keywords" content="<?php echo e($blog->meta_keywords ?? ''); ?>" />

  <meta property="twitter:image" content="<?php echo e(asset($blog->image ?? '')); ?>" />


<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

 <section class="about-page-banner-section" style="background-image: url(<?php echo e(asset('public/frontend/')); ?>/images/tour-package.jpg);">
    <div class="container">
        <div class="about-slug text-center">
            <h2 class="">Contact Us</h2>
        </div>
    </div>
    <div class="about-page-banner-overlay">

    </div>
 </section>

 <section class="company-overview-container-section">
    <div class="container">
        <iframe src="<?php echo e($site_info->google_map_embed); ?>" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
    </div>
 </section>

 <div class="contact-info-section">
    <div class="container">
        <div class="row g-4">
            <div class="col-md-4">
                <div class="contact-info-cart text-center">
                   <div class="text-center">
                    <img src="../images/location.png" alt="">
                   </div>
                   <h4>Find Us at</h4>
                   <p><?php echo e($site_info->address); ?></p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="contact-info-cart text-center">
                   <div class="text-center">
                    <img src="../images/gmail.png" alt="">
                   </div>
                   <h4>Email Us at</h4>

                    <?php
                        $emails = explode(", ", $site_info->email);
                        $totalEmails = count($emails);
                        $i = 1;
                        $icon = '<i class="fa-solid fa-envelope"></i>';
                    ?>
                    <?php $__currentLoopData = $emails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <p class="mb-0 text-center"><a href="mailto:<?php echo e($item); ?>"><?php echo e($item); ?></a></p>

                      <?php $i++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                </div>
            </div>
            <div class="col-md-4">
                <div class="contact-info-cart text-center">
                   <div class="text-center">
                    <img src="../images/phone-call.png" alt="">
                   </div>
                   <h4>Call Us at</h4>

                      <?php
                          $phones = explode(", ", $site_info->phone_number);
                          $totalPhones = count($phones);
                          $i = 1;
                          $icon = '<i class="fa-solid fa-phone"></i>';
                      ?>

                      <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                        <p class="mb-0 text-center"><a href="tel:<?php echo e($item); ?> "><?php echo e($item); ?> </a></p>


                        <?php $i++; ?>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </div>
    </div>
 </div>

 <section class="get-in-touch-section">
    <div class="container">
        <div class="get-in-touch-title text-center">
            <h2>Get In Touch</h2>
        </div>
        <div class="row g-4">
            <div class="col-md-6">
                <div class="get-in-touch-info">
                    
                    <?php echo $page_des->contact_page_description; ?>


                </div>
            </div>
            <div class="col-md-6">
                <div class="get-in-touch-form">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    
                    <form action="<?php echo e(route('submit_message')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="single-input mb-3">
                            <input type="text" name="full_name" class="form-control shadow-none" placeholder="Enter Your Name">
                        </div>
                        <div class="single-input mb-3">
                            <input type="text" name="phone_number"  class="form-control shadow-none" placeholder="Entry Your Contact Number">
                        </div>
                     
                        <div class="single-input mb-3">
                            <textarea  name="message" id="" cols="10" rows="4" class="form-control shadow-none" placeholder="Your Massage"></textarea>
                        </div>
                        <div class="single-input mb-3">
                          <button  type="submit" class="btn w-100">SEND MESSAGE <i class="fa-solid fa-paper-plane"></i></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
 </section>
  

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\office\obokash_tour\resources\views/frontend/pages/contact.blade.php ENDPATH**/ ?>