
<?php $__env->startSection('head'); ?>
<title> <?php echo e($category->name); ?> Blog | <?php echo e($site_info->name ?? ''); ?></title>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <meta name="description" content="<?php echo e($site_info->meta_description ?? ''); ?>" />

  <meta property="type" content="Website" />

  <link rel="canonical" href="<?php echo e($host); ?>" />

  <meta name="robots" content="index,allow" />

  <meta name="author" content="<?php echo e($site_info->name ?? ''); ?>" />

  <meta name="publisher" content="<?php echo e($site_info->name ?? ''); ?>" />

  <meta property="site_name" content=" <?php echo e($category->name); ?> Blog | <?php echo e($site_info->name ?? ''); ?>" />

  <meta property="og:url" content="<?php echo e($host); ?>/" />

  <meta property="og:type" content="website" />

  <meta property="og:title" content=" <?php echo e($category->name); ?> Blog | <?php echo e($site_info->name ?? ''); ?>" />

  <meta property="og:description" content="<?php echo e($site_info->meta_description ?? ''); ?>" />

  <meta property="og:keywords" content="<?php echo e($site_info->meta_keywords ?? ''); ?>" />

  <meta property="og:image" content="<?php echo e(asset($site_info->meta_image ?? '')); ?>" />

  <meta name="twitter:card" content="summary" /><meta name="twitter:site" content="{{ $site_info->name ?? '' }}" />

  <meta name="twitter:creator" content="@ <?php echo e($site_info->name ?? ''); ?>" />

  <meta property="twitter:url" content="<?php echo e($host); ?>/" />

  <meta property="twitter:title" content=" <?php echo e($category->name); ?> Blog | <?php echo e($site_info->name ?? ''); ?>" />

  <meta property="twitter:description" content="<?php echo e($site_info->meta_description ?? ''); ?>" />

  <meta property="twitter:keywords" content="<?php echo e($site_info->meta_keywords ?? ''); ?>" />

  <meta property="twitter:image" content="<?php echo e(asset($site_info->meta_image ?? '')); ?>" />


<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


 <section class="about-page-banner-section">
    <div class="container">
        <div class="about-slug text-center">
            <h2 class=""> <?php echo e($category->name); ?></h2>
        </div>
    </div>
    <div class="about-page-banner-overlay"></div>
 </section>

 <section class="company-overview-container-section">
    <div class="container">
      <div class="row g-4">
        <div class="col-md-8">
            <div class="blog-list-container">
                <div class="d-flex justify-content-between all-blog-badge-title">
                    <div class="all-blog-badge">
                        <h3>All Blogs of  <?php echo e($category->name); ?> category <button> <?php echo e($blogs->count()); ?> </button></h3>
                    </div>
                    <div></div>
                </div>
                <div class="row g-4">


                	<?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-12">
                        <div class="blog-cart">
                           <div class="row">
                            <div class="col-md-3">
                                <div class="blog-thumbnail text-center">
                                    <img src="<?php echo e(asset($item->image)); ?>" alt="<?php echo e($item->title); ?>">
                                </div>
                            </div>
                            <div class="col-md-9">
                                <div class="blog-sort-details">
                                    <h4><a href="<?php echo e(route('blog', ['id' => $item->id, 'slug' => $item->slug])); ?>"> <?php echo e($item->title); ?> </a></h4>
                                    <p class="post-author m-2"><span> <i class="fa-solid fa-user"></i> Admin</span> <span><i class="fa-solid fa-calendar-days"></i>  <?php echo e(Carbon\Carbon::parse($item->created_at)->format('M-d-Y')); ?> </span></p>
                                    <div class="blog-like-btn-wrapper">

                                        <!-- <button class="btn bg-primary text-white shadow-none"><span><i class="fa-solid fa-thumbs-up"></i></span> Like <span>0</span></button> -->

                                        <!-- <button class="btn bg-primary text-white shadow-none">Share</button> -->


										<a class="btn bg-primary text-white shadow-none" href="https://api.whatsapp.com/send?text=<?php echo e(route('blog', ['id' => $item->id, 'slug' => $item->slug])); ?>" data-action="share/whatsapp/share" target="_blank" style="padding: 1px 15px;background: #00A884 !important;"> <span style="    font-size: 8px; font-weight: 700;">Whatsapp</span>  </a>


                                        <div class="fb-share-button" data-href="<?php echo e(route('blog', ['id' => $item->id, 'slug' => $item->slug])); ?>" data-layout="button_count" data-size="small"><a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fdaily24newsbd.com%2Fpm-urges-parents-to-encourage-their-children-to-play-outside&amp;src=sdkpreparse" class="fb-xfbml-parse-ignore">Share</a></div>


                                    </div>
                                    <div>
                                        <p> <?php echo $item->meta_description; ?></p>
                                    </div>
                                    <div class="single-blog-read-more-btn">
                                        <a href="<?php echo e(route('blog', ['id' => $item->id, 'slug' => $item->slug])); ?>" class="text-uppercase">read more <i class="fa-solid fa-arrow-right"></i></a>
                                    </div>

                                </div>
                            </div>
                           </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php echo e($blogs->links()); ?>




                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="blog-category-list-wrapper ps-md-5">
                <div class="our-services">
                    <h4 class="text-uppercase">Blog Cagegories</h4>
                    <ul>

                    	<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><a href="<?php echo e(route('category', ['id' => $item->id, 'slug' => $item->slug])); ?>"><?php echo e($item->name); ?></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </ul>
                </div>
                
                <?php echo $__env->make('frontend.components.sidebar_tour_packages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                <?php echo $__env->make('frontend.components.sidebar_umrah_packages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                <?php echo $__env->make('frontend.components.sidebar_visa_packages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


            </div>
        </div>
      </div>
    </div>
 </section>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\office\obokash_tour\resources\views/frontend/pages/category_wise_blogs.blade.php ENDPATH**/ ?>