

<?php $__env->startSection('title'); ?>
<title> Manage course | <?php echo e(config('app.name')); ?>  </title>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">course</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">course</a></li>
                                    <li class="breadcrumb-item active">List View</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div id="instructorList">

                  

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row align-items-center g-2">
                                        <div class="col-lg-3 me-auto">
                                            <h6 class="card-title mb-0">course List<span class="badge bg-primary ms-1 align-baseline"> <?php echo e($datas->count()); ?> </span></h6>
                                        </div><!--end col-->
                                
                                        <div class="col-sm-auto">
                                            <div class="hstack gap-2">
                                            

                                                <a href="<?php echo e(route('course.create')); ?>" class="btn btn-secondary"><i class="bi bi-plus-circle align-baseline me-1"></i> Add course</a>
                                            </div>
                                        </div><!--end col-->
                                    </div>
                                </div>
                                <div class="card-body mt-3">
                                    <div class="table-responsive table-card">
                                        <table id="" class="table table-centered align-middle table-custom-effect table-nowrap mb-0">
                                            <thead class="table-light">
                                                <tr>
                                                   
                                                    <th scope="col" class="sort cursor-pointer" data-sort="instructor_id">SL</th>
                                                    <th scope="col" class="sort cursor-pointer" data-sort="instructor"> IMAGE</th> 
                                                    <th scope="col" class="sort cursor-pointer" data-sort="instructor"> LEVEL</th> 
                                                    <th scope="col" class="sort cursor-pointer" data-sort="instructor"> IS PAID</th> 
                                                    <th scope="col" class="sort cursor-pointer" data-sort="instructor"> NAME</th> 
                                                    <th scope="col" class="sort cursor-pointer" data-sort="instructor"> REGULAR PRICE</th> 
                                                    <th scope="col" class="sort cursor-pointer" data-sort="instructor"> DISCOUNT PRICE</th> 
                                                    <th scope="col" class="sort cursor-pointer" data-sort="instructor"> STATUS</th> 
                                                                                          
                                                    <th scope="col">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody class="list form-check-all">

                                            	<?php $i = 1 ?>
                                            	<?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                  
                                                   
                                                    <td class="courses_total"><?php echo e($i++); ?></td>
                                                    
                                                    <td class="courses_total"> 

                                                    	<img src="<?php echo e(asset($item->image)); ?>" alt="" style="width: 100px;">

                                                    </td>

                                                    <td class="courses_total"><?php echo e($item->level->name ?? ''); ?></td>

                                                    <td class="courses_total">
                                                    	
                                                    	<?php if($item->isPaid): ?>

                                                    		<span class="badge bg-success">PAID</span>

                                                    	<?php else: ?>

                                                    		<span class="badge bg-danger">FREE</span>

                                                    	<?php endif; ?>

                                                    </td>

                                                    <td class="courses_total"><?php echo e($item->name ?? ''); ?></td>


                                                    <td class="courses_total"><?php echo e($item->regular_price ?? 0); ?></td>

                                                    <td class="courses_total"><?php echo e($item->discount_price ?? 0); ?></td>

                                                    <td class="courses_total">
                                                            
                                                        <?php if($item->status == 1): ?>

                                                            <span class="badge bg-success">ACTIVE</span>

                                                        <?php else: ?>

                                                            <span class="badge bg-danger">INACTIVE</span>

                                                        <?php endif; ?>

                                                    </td>

                                                   
                                                   
                                                    <td>
                                                        <ul class="d-flex gap-2 list-unstyled mb-0">
                                                          
                                                            <li>
                                                                <a href="<?php echo e(URL::to('admin/course/'.$item->id.'/edit')); ?>"  class="btn btn-subtle-secondary btn-icon btn-sm edit-item-btn"><i class="ph-pencil"></i></a>
                                                            </li>
                                                            <li>

										                        <form action="<?php echo e(URL::to('admin/course/'.$item->id)); ?>" method="post" onsubmit="return confirm('Do you really want to delete this data ?');">

										                          <?php echo csrf_field(); ?>

										                          <?php echo method_field('DELETE'); ?>

										                          <button  class="btn btn-subtle-danger btn-icon btn-sm remove-item-btn" type="submit">
										                          	<i class="ph-trash"></i>
										                          	</button>

										                        </form>

                                                            </li>
                                                        </ul>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </tbody><!-- end tbody -->
                                        </table><!-- end table -->
                                
                                    </div>
                          
                                </div>
                            </div>
                        </div><!--end col-->
                    </div><!--end row-->

                </div>

            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->

    </div>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\office\gravity_new\resources\views/admin/course/index.blade.php ENDPATH**/ ?>